%% 
clc;clear;
mask_tp=zeros(1800,3600);
[lon lat]=meshgrid([-180:0.10001:180],[-90:0.10001:90]);
tibet=shaperead('C:\Users\DELL\Desktop\ظԭ߽\DBATP(ض)\Tibetan.shp');
lat=flipud(lat); lon=flipud(lon);

isin=inpolygon(lon,lat,tibet.X,tibet.Y);
mask_tp(~isin)=NaN;

save('D:\Ѽ\1ѿ\ظԭ__\warming\mask_tp.mat','mask_tp');


clc;clear; %%% 
lon_res_05deg=360/3600;
lat_res_05deg=180/1800;
lon_05deg = -179.99:lon_res_05deg:179.99;
lat_05deg=-89.99:lat_res_05deg:89.99;
[glon_05deg,glat_05deg] = meshgrid(lon_05deg,lat_05deg);
[nlat_05deg,nlon_05deg] = size(glon_05deg);

display('Generating Area Mask ...');
map = ones(nlat_05deg,nlon_05deg);
R = georasterref('RasterSize', [nlat_05deg nlon_05deg], ...
      'RasterInterpretation', 'cells', 'ColumnsStartFrom', 'north', ...
      'LatitudeLimits', [lat_05deg(1) lat_05deg(end)], 'LongitudeLimits', [lon_05deg(1) lon_05deg(end)]);
ellipsid = referenceEllipsoid('Earth','km');  
[~,areavec] = areamat(map,R,ellipsid);  
[~,map_area0] = meshgrid(lon_05deg,areavec);
area_01_km2 = flipud(map_area0);

save('D:\Ѽ\1ѿ\ظԭ__\warming\area_01_km2.mat','area_01_km2');



%% optimized (FUN constrained_all); related to inferred_shi
clc;clear;
load('D:\Ѽ\4 paper-C turnover\2.\CRU_ts4.01\2. ˮ\pre.mat');
load('D:\Ѽ\4 paper-C turnover\2.\CRU_ts4.01\1. ¶\tmp.mat');
load('D:\Ѽ\1ѿ\ظԭ__\warming\mask_tp.mat','mask_tp');

fc=imread('D:\Ѽ\1ѿ\ظԭ__\warming\upscaling_turnover\fcp_tp_005.tif');
fc=double(fc); fc(fc<0)=nan;
sc=imread('D:\Ѽ\1ѿ\ظԭ__\warming\upscaling_turnover\scp_tp_005.tif');
sc=double(sc); sc(sc<0)=nan;
fmrt=imread('D:\Ѽ\1ѿ\ظԭ__\warming\upscaling_turnover\fmrt_tp_005.tif');
fmrt=double(fmrt); fmrt(fmrt<0)=nan;
smrt=imread('D:\Ѽ\1ѿ\ظԭ__\warming\upscaling_turnover\smrt_tp_005.tif');
smrt=double(smrt); smrt(smrt<0)=nan;
pmrt=imread('D:\Ѽ\1ѿ\ظԭ__\warming\upscaling_turnover\pmrt_tp_005.tif');
pmrt=double(pmrt); pmrt(pmrt<0)=nan;

fc=imresample([0.05,0.05],fc,[0.1,0.1],'nearest'); 
sc=imresample([0.05,0.05],sc,[0.1,0.1],'nearest'); 
fmrt=imresample([0.05,0.05],fmrt,[0.1,0.1],'nearest'); 
smrt=imresample([0.05,0.05],smrt,[0.1,0.1],'nearest');
pmrt=imresample([0.05,0.05],pmrt,[0.1,0.1],'nearest'); 

% load('D:\Ѽ\5 һƪ\һ-ķ\MODISݲƷ\npp_05.mat'); npp1=nan(20,720); npp2=nan(60,720); npp=cat(1,npp1,npp05,npp2); npp=imresample([0.5,0.5],npp,[0.09987,0.09976],'nearest'); %%% gC/m2/year
npp=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_00_15_TP_01.tif');
npp=double(npp)/10; npp(npp>6500)=nan;
mask_fc=fc; mask_fc(mask_fc>0)=0;
npp=npp+mask_fc;


grids_oc=imread('D:\Ѽ\1ѿ\ظԭ__\variables\socd\TP_1m_SOCD_kgCm2_01.tif');%%% λΪ kg/m2;
load('D:\Ѽ\4 paper-C turnover\2.\SoilGrids\Clay content\clay_01.mat');
clay_01=mean(clay_01,3,'omitnan')/100; 
load('D:\Ѽ\4 paper-C turnover\2.\SoilGrids\Bulk density\bd_01.mat');
bd_01=mean(bd_01,3,'omitnan'); 


mca=ncread('D:\Ѽ\4 paper-C turnover\2.\Shizheng NG\global_age.nc','temp');
mca=mean(mca,3,'omitnan'); mca=double(mca);
mca=mca'; mca=flipud(mca);
mca=imresample([0.5,0.5],mca,[0.09987,0.09976],'nearest');

pre(:,:,[1:99 end])=[]; tmp(:,:,[1:99 end])=[];%%%% 2000-2015
pre=mean(pre,3,'omitnan'); tmp=mean(tmp,3,'omitnan');
pre=imresample([0.5,0.5],pre,[0.09987,0.09976],'nearest'); tmp=imresample([0.5,0.5],tmp,[0.09987,0.09976],'nearest');


load('D:\Ѽ\4 paper-C turnover\7.Physical protection\3.constrain_hamdi\1 changed_all\max_pre.mat','max_pre');
% max_pre=max(pre(:)); 
% save('D:\Ѽ\4 paper-C turnover\7.Physical protection\3.constrain_hamdi\1 changed_all\max_pre.mat','max_pre');
pre=pre/max_pre;


load('D:\Ѽ\1ѿ\ظԭ__\warming\area_01_km2.mat','area_01_km2');
mask_area1=area_01_km2;
mask_area1=mask_area1+mask_tp; mask_area1=mask_area1(501:650,2501:2850);
grids_oc=(grids_oc.*mask_area1)/(10^6);
npp=(npp.*mask_area1)*10^6/(10^15);

tmp=tmp+mask_tp; tmp=tmp(501:650,2501:2850);
pre=pre+mask_tp; pre=pre(501:650,2501:2850);

% grids_oc=grids_oc+mask_tp; grids_oc=grids_oc(501:650,2501:2850);
mca=mca+mask_tp; mca=mca(501:650,2501:2850);
clay_01=clay_01+mask_tp; clay_01=clay_01(501:650,2501:2850);
bd_01=bd_01+mask_tp; bd_01=bd_01(501:650,2501:2850);

nu=52500;

hst=reshape(tmp,[1,nu]);
hswc=reshape(pre,[1,nu]);
hfs=reshape(npp,[1,nu]);
fc=reshape(fc,[1,nu]);
sc=reshape(sc,[1,nu]);
fmrt=reshape(fmrt,[1,nu]);
smrt=reshape(smrt,[1,nu]);
pmrt=reshape(pmrt,[1,nu]);
grids_oc=reshape(grids_oc,[1,nu]);
mca=reshape(mca,[1,nu]);
clay_01=reshape(clay_01,[1,nu]);
bd_01=reshape(bd_01,[1,nu]);
mask_area1=reshape(mask_area1,[1,nu])*10^6;
bd_01=bd_01.*mask_area1/10;

ctotal=grids_oc; 
hcfs=ctotal.*fc; hcms=ctotal.*sc; hcss=ctotal.*(1-fc-sc);
pc=1-fc-sc;
mrt=cat(1,fmrt,smrt,pmrt,fc,sc,pc,mca,clay_01,bd_01);

clearvars -except hfs mrt hcfs hcms hcss hst hswc iseed

path='D:\Ѽ\1ѿ\ظԭ__\warming\';

iseed=20231204.1437;
% rand('seed',iseed);
% had1=constrained_all(hfs, mrt, hcfs, hcms, hcss, hst, hswc);

% save(strcat(path,'constrainPAR.mat'),'had1');
save(strcat(path,'constrain_TP_service.mat'),'iseed','hfs', 'mrt', 'hcfs', 'hcms', 'hcss', 'hst', 'hswc');


% clc;clear;
% 
% npp=reshape(had1(1,:),150,350);
% 
% tibet=shaperead('C:\Users\DELL\Desktop\ظԭ߽\DBATP(ض)\Tibetan.shp');
% fig=figure('color','white','Visible','on');
% set(gcf,'unit','centimeters','position',[20,5,10,15]);
% lon_l=70; lon_r=105; lon_g=(lon_r-lon_l)./350;
% lat_d=25; lat_u=40;lat_g=(lat_u-lat_d)./150;
% [LON,LAT]=meshgrid(lon_l+lon_g/2:lon_g:lon_r,lat_u-lat_g/2:-lat_g:lat_d);
% pcolor(LON,LAT,npp);
% shading interp;
% geoshow(tibet.Y,tibet.X,'color',[0.1,0.1,0.1]);
% colormap('jet');


%% sin-up
clc;clear;
% load('D:\Ѽ\5 һƪ\һ-ķ\MODISݲƷ\npp00_15.mat','npp');
load('D:\Ѽ\1ѿ\ظԭ__\warming\mask_tp.mat','mask_tp');

load('D:\Ѽ\4 paper-C turnover\2.\CRU_ts4.01\2. ˮ\pre.mat');
load('D:\Ѽ\4 paper-C turnover\2.\CRU_ts4.01\1. ¶\tmp.mat');

fc=imread('D:\Ѽ\1ѿ\ظԭ__\warming\upscaling_turnover\fcp_tp_005.tif');
fc=double(fc); fc(fc<0)=nan;
sc=imread('D:\Ѽ\1ѿ\ظԭ__\warming\upscaling_turnover\scp_tp_005.tif');
sc=double(sc); sc(sc<0)=nan;
fmrt=imread('D:\Ѽ\1ѿ\ظԭ__\warming\upscaling_turnover\fmrt_tp_005.tif');
fmrt=double(fmrt); fmrt(fmrt<0)=nan;
smrt=imread('D:\Ѽ\1ѿ\ظԭ__\warming\upscaling_turnover\smrt_tp_005.tif');
smrt=double(smrt); smrt(smrt<0)=nan;
pmrt=imread('D:\Ѽ\1ѿ\ظԭ__\warming\upscaling_turnover\pmrt_tp_005.tif');
pmrt=double(pmrt); pmrt(pmrt<0)=nan;

fc=imresample([0.05,0.05],fc,[0.1,0.1],'nearest'); 
sc=imresample([0.05,0.05],sc,[0.1,0.1],'nearest'); 
fmrt=imresample([0.05,0.05],fmrt,[0.1,0.1],'nearest'); 
smrt=imresample([0.05,0.05],smrt,[0.1,0.1],'nearest');
pmrt=imresample([0.05,0.05],pmrt,[0.1,0.1],'nearest'); 


npp2000=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2000_TP_01.tif');
npp2001=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2001_TP_01.tif');
npp2002=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2002_TP_01.tif');
npp2003=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2003_TP_01.tif');
npp2004=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2004_TP_01.tif');
npp2005=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2005_TP_01.tif');
npp2006=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2006_TP_01.tif');
npp2007=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2007_TP_01.tif');
npp2008=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2008_TP_01.tif');
npp2009=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2009_TP_01.tif');
npp2010=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2010_TP_01.tif');
npp2011=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2011_TP_01.tif');
npp2012=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2012_TP_01.tif');
npp2013=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2013_TP_01.tif');
npp2014=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2014_TP_01.tif');
npp2015=imread('D:\Ѽ\1ѿ\ظԭ__\variables\modis_npp_tp\modis_npp_2015_TP_01.tif');

npp=cat(3,npp2000,npp2001,npp2002,npp2003,npp2004,npp2005,npp2006,npp2007,npp2008,npp2009,npp2010,npp2011,npp2012,npp2013,npp2014,npp2015);
npp=double(npp)/10; npp(npp>6500)=nan;
mask_fc=fc; mask_fc(mask_fc>0)=0;

for i=1:16
    npp(:,:,i)=npp(:,:,i)+mask_fc;
end


grids_oc=imread('D:\Ѽ\1ѿ\ظԭ__\variables\socd\TP_1m_SOCD_kgCm2_01.tif');%%% λΪ kg/m2;
load('D:\Ѽ\4 paper-C turnover\2.\SoilGrids\Clay content\clay_01.mat');
clay_01=mean(clay_01,3,'omitnan')/100; 
load('D:\Ѽ\4 paper-C turnover\2.\SoilGrids\Bulk density\bd_01.mat');
bd_01=mean(bd_01,3,'omitnan'); 


load('D:\Ѽ\1ѿ\ظԭ__\warming\area_01_km2.mat','area_01_km2');
mask_area1=area_01_km2;
mask_area1=mask_area1+mask_tp; mask_area1=mask_area1(501:650,2501:2850);
grids_oc=(grids_oc.*mask_area1)/(10^6);

pre(:,:,[1:99 end])=[]; tmp(:,:,[1:99 end])=[];%%%% 2000-2015
pre=imresample([0.5,0.5],pre,[0.09987,0.09976],'nearest'); tmp=imresample([0.5,0.5],tmp,[0.09987,0.09976],'nearest');


load('D:\Ѽ\4 paper-C turnover\7.Physical protection\3.constrain_hamdi\1 changed_all\max_pre.mat','max_pre');
for i=1:16
    pre(:,:,i)=pre(:,:,i)/max_pre;
    npp(:,:,i)=(npp(:,:,i).*mask_area1)*10^6/(10^15);
end

for i=1:16
    pre(:,:,i)=pre(:,:,i)+mask_tp;
    tmp(:,:,i)=tmp(:,:,i)+mask_tp;
end

tmp=tmp(501:650,2501:2850,:);
pre=pre(501:650,2501:2850,:);

clay_01=clay_01+mask_tp; clay_01=clay_01(501:650,2501:2850);
bd_01=bd_01+mask_tp; bd_01=bd_01(501:650,2501:2850);

nu=52500;
for i=1:15
    hst(i,:)=reshape(tmp(:,:,i),[1,nu]);
    hswc(i,:)=reshape(pre(:,:,i),[1,nu]);
    hfs(i,:)=reshape(npp(:,:,i),[1,nu]);
end
fc=reshape(fc,[1,nu]);
sc=reshape(sc,[1,nu]);
fmrt=reshape(fmrt,[1,nu]);
smrt=reshape(smrt,[1,nu]);
pmrt=reshape(pmrt,[1,nu]);
grids_oc=reshape(grids_oc,[1,nu]);
clay_01=reshape(clay_01,[1,nu]);
bd_01=reshape(bd_01,[1,nu]);
mask_area1=reshape(mask_area1,[1,nu])*10^6;
bd_01=bd_01.*mask_area1/10;

ctotal=grids_oc;
hcfs=ctotal.*fc; hcms=ctotal.*sc; hcss=ctotal.*(1-fc-sc);
mrt=cat(1,fmrt,smrt,pmrt,clay_01,bd_01);

%%% ģ׼ȷ
path='D:\Ѽ\1ѿ\ظԭ__\warming\';
load(strcat(path,'consPAR_TP.mat'));

hfs_mo(1,:)=hcfs(1,:); hms_mo(1,:)=hcms(1,:); hss_mo(1,:)=hcss(1,:);
for j=1:nu
    cm_last(1,1)=hcfs(1,j); cm_last(2,1)=hcms(1,j); cm_last(3,1)=hcss(1,j);
    for i=1:5000
        a=i;
        if i>15
            if mod(i,15)>0;
                i=mod(i,15);
            else
                i=15;
            end
        end
        st(i,1)=hst(i,j); swc(i,1)=hswc(i,j);
        f_tem=had1(4,j)^((st(i,1)-15)/10); s_tem=had1(5,j)^((st(i,1)-15)/10); p_tem=had1(6,j)^((st(i,1)-15)/10);
        f_moi=(swc(i,1))^had1(3,j); s_moi=(swc(i,1))^had1(3,j); p_moi=(swc(i,1))^had1(3,j);
        f=mrt(1,j); s=mrt(2,j); p=mrt(3,j);
        if mrt(4,j)==0
            clay=1;
        elseif mrt(4,j)>0 && mrt(4,j)<0.033
            clay=1/(mrt(4,j)*19.6);
        elseif mrt(4,j)>0.033 || mrt(4,j)==0.033
            clay=1/(-2.13*mrt(4,j)^2+6.23*mrt(4,j)+0.55);
        else
            clay=nan;
        end
        
        f_app=mrt(1,j)/(f_tem*f_moi*clay);
        if cm_last(1,1)>0
            s_in=cm_last(1,1)*had1(1,j)/f_app;
            cm_present2(1,1)=(1-1/f_app)*cm_last(1,1)+hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(cm_last(1,1)+hfs(i,j))*had1(1,j);
            end
        else
            s_in=hfs(i,j)*had1(1,j)/f_app;
            cm_present2(1,1)=(1-1/f_app)*hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(hfs(i,j))*had1(1,j);
            end
        end
        s_res=s_in*10^14*7.05/(365*mrt(5,j));
        s_pri=1+((2.47*s_res)/(13.01+s_res));
        s_app=mrt(2,j)/(s_tem*s_moi*clay)/s_pri;
        
        p_in=cm_last(2,1)*had1(2,j)/s_app;
        p_res=p_in*10^14*7.05/(365*mrt(5,j));
        p_pri=1+((2.47*p_res)/(13.01+p_res));
        
        p_app=mrt(3,j)/(p_tem*p_moi*clay)/p_pri;
        
        if cm_last(1,1)>0
            cm_present(1,1)=(1-1/f_app)*cm_last(1,1)+hfs(i,j);
            cm_present(2,1)=(1-1/s_app)*cm_last(2,1)+cm_last(1,1)*had1(1,j)/f_app;
            cm_present(3,1)=(1-1/p_app)*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app;
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app)*cm_last(2,1)+(cm_last(1,1)+hfs(i,j))*had1(1,j);
                cm_present(3,1)=(1-1/p_app)*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app;
            end
        else
            cm_present(1,1)=(1-1/f_app)*hfs(i,j);
            cm_present(2,1)=(1-1/s_app)*cm_last(2,1)+hfs(i,j)*had1(1,j)/f_app;
            cm_present(3,1)=(1-1/p_app)*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app;
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app)*cm_last(2,1)+hfs(i,j)*had1(1,j);
                cm_present(3,1)=(1-1/p_app)*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app;
            end
        end
        cm_last=cm_present;
        hfs_mo(a+1,j)=cm_present(1,1); hms_mo(a+1,j)=cm_present(2,1); hss_mo(a+1,j)=cm_present(3,1);
    end
end


mask_f=mean(hfs_mo(end-15:end,:),1,'omitnan')./hfs_mo(1,:);
mask_m=mean(hms_mo(end-15:end,:),1,'omitnan')./hms_mo(1,:);
mask_s=mean(hss_mo(end-15:end,:),1,'omitnan')./hss_mo(1,:);

mask_f(find(mask_f>100))=nan; mask_m(find(mask_m>100))=nan; mask_s(find(mask_s>100))=nan;

mask=mask_f+mask_m+mask_s; mask(mask>-100)=0;

for j=1:size(hfs_mo,1)
    hfs_mo(j,:)=hfs_mo(j,:)+mask;
    hfs=hfs_mo(j,:);
    hfs1(j,1)=sum(hfs(:),'omitnan');
    hms_mo(j,:)=hms_mo(j,:)+mask;
    hms=hms_mo(j,:);
    hfs1(j,2)=sum(hms(:),'omitnan');
    hss_mo(j,:)=hss_mo(j,:)+mask;
    hss=hss_mo(j,:);
    hfs1(j,3)=sum(hss(:),'omitnan');
end


yr=1:size(hfs1,1);
subplot(1,3,1)
plot(yr',hfs1(:,1));
ylabel('Soil carbon stocks (pg C)');
title('Fast pool');

subplot(1,3,2)
plot(yr',hfs1(:,2));
ylabel('Soil carbon stocks (pg C)');
title('Medium pool');

subplot(1,3,3)
plot(yr',hfs1(:,3));
ylabel('Soil carbon stocks (pg C)');
title('Slow pool');


a=sum(hfs1,2);
b(1,1)=a(1,1); b(1,2:4)=mean(hfs1(1,:),1); b(1,5)=mean(a(end-15:end,1)); b(1,6:8)=mean(hfs1(end-15:end,:)); 

hfs1=cat(2,yr',hfs1);
hfs1= array2table(hfs1,...
    'VariableNames',{'times','f_spinup','m_spinup','s_spinup'});

hfs_mo(1:end-16,:)=[];
hms_mo(1:end-16,:)=[];
hss_mo(1:end-16,:)=[];

save(strcat(path,'soc_spinup.mat'),'hfs_mo','hms_mo','hss_mo'); writetable(hfs1,strcat(path,'soc_spinup_yearly.csv'),'WriteRowNames',false);


%% ACCESS-ESM1-5; prediction-ssp585; constrain; use forѭ
clc;clear;
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histnpp_stocks.mat','access_histnpp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histtas.mat','access_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histpr.mat','access_histpr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/ACCESS-ESM1-5/access_ssp585npp_stocks.mat','access_ssp585npp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/ACCESS-ESM1-5/access_ssp585tas.mat','access_ssp585tas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/ACCESS-ESM1-5/access_ssp585pr.mat','access_ssp585pr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/2. ˮ/pre.mat');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/1. ¶/tmp.mat');
load('/Users/shuairen/Desktop/ظԭ__/warming/mask_tp.mat','mask_tp');

fc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fcp_tp_005.tif');
fc=double(fc); fc(fc<0)=nan;
sc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/scp_tp_005.tif');
sc=double(sc); sc(sc<0)=nan;
fmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fmrt_tp_005.tif');
fmrt=double(fmrt); fmrt(fmrt<0)=nan;
smrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/smrt_tp_005.tif');
smrt=double(smrt); smrt(smrt<0)=nan;
pmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/pmrt_tp_005.tif');
pmrt=double(pmrt); pmrt(pmrt<0)=nan;

fc=imresample([0.05,0.05],fc,[0.1,0.1],'nearest');
sc=imresample([0.05,0.05],sc,[0.1,0.1],'nearest');
fmrt=imresample([0.05,0.05],fmrt,[0.1,0.1],'nearest');
smrt=imresample([0.05,0.05],smrt,[0.1,0.1],'nearest');
pmrt=imresample([0.05,0.05],pmrt,[0.1,0.1],'nearest');


npp2000=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2000_TP_01.tif');
npp2001=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2001_TP_01.tif');
npp2002=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2002_TP_01.tif');
npp2003=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2003_TP_01.tif');
npp2004=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2004_TP_01.tif');
npp2005=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2005_TP_01.tif');
npp2006=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2006_TP_01.tif');
npp2007=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2007_TP_01.tif');
npp2008=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2008_TP_01.tif');
npp2009=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2009_TP_01.tif');
npp2010=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2010_TP_01.tif');
npp2011=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2011_TP_01.tif');
npp2012=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2012_TP_01.tif');
npp2013=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2013_TP_01.tif');
npp2014=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2014_TP_01.tif');
npp2015=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2015_TP_01.tif');

npp=cat(3,npp2000,npp2001,npp2002,npp2003,npp2004,npp2005,npp2006,npp2007,npp2008,npp2009,npp2010,npp2011,npp2012,npp2013,npp2014,npp2015);
npp=double(npp)/10; npp(npp>6500)=nan;
mask_fc=fc; mask_fc(mask_fc>0)=0;

for i=1:16
    npp(:,:,i)=npp(:,:,i)+mask_fc;
end

grids_oc=imread('/Users/shuairen/Desktop/ظԭ__/variables/socd/TP_1m_SOCD_kgCm2_01.tif');%%% λΪ kg/m2;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Clay content/clay_01.mat');
clay_01=mean(clay_01,3,'omitnan')/100;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Bulk density/bd_01.mat');
bd_01=mean(bd_01,3,'omitnan');

load('/Users/shuairen/Desktop/ظԭ__/warming/area_01_km2.mat','area_01_km2');
mask_area1=area_01_km2;
mask_area1=mask_area1+mask_tp; mask_area1=mask_area1(501:650,2501:2850);

grids_oc=(grids_oc.*mask_area1)/(10^6);


for i=1:16
    npp(:,:,i)=(npp(:,:,i).*mask_area1)*10^6/(10^15);
end
npp(:,:,end)=[];


pre(:,:,[1:99 115:end])=[]; tmp(:,:,[1:99 115:end])=[];%%%% 2000-2015
pre=imresample([0.5,0.5],pre,[0.09987,0.09976],'nearest'); tmp=imresample([0.5,0.5],tmp,[0.09987,0.09976],'nearest');

for i=1:15
    pre(:,:,i)=pre(:,:,i)+mask_tp;
    tmp(:,:,i)=tmp(:,:,i)+mask_tp;
end

tmp=tmp(501:650,2501:2850,:);
pre=pre(501:650,2501:2850,:);


access_histnpp_stocks(:,:,1:150)=[]; access_histpr(:,:,1:150)=[]; access_histtas(:,:,1:150)=[];
access_npp1=cat(3,access_histnpp_stocks,access_ssp585npp_stocks);
access_pr1=cat(3,access_histpr,access_ssp585pr);
access_tas1=cat(3,access_histtas,access_ssp585tas);


%%%% delta method
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/mask_area.mat','mask_area');
deg_lo=360/192; deg_la=180/145;

for i=1:101
    st=access_tas1(:,:,i);
    st=imresample([deg_lo deg_la],st,[0.0995,0.09935],'nearest');
    st=st+mask_tp; st=st(501:650,2501:2850);
    access_tas(:,:,i)=st;
    
    pr=access_pr1(:,:,i);
    pr=imresample([deg_lo deg_la],pr,[0.0995,0.09935],'nearest');
    pr=pr+mask_tp; pr=pr(501:650,2501:2850);
    access_pr(:,:,i)=pr;
    
    fvs=access_npp1(:,:,i);
    fvs=fvs./mask_area;
    fvs=imresample([deg_lo deg_la],fvs,[0.0995,0.09935],'nearest');
    fvs=fvs.*area_01_km2;
    fvs=fvs+mask_tp; fvs=fvs(501:650,2501:2850);
    access_npp(:,:,i)=fvs;
end


a=access_tas(:,:,1:15); access_tas(:,:,1:15)=[];
b=access_pr(:,:,1:15); access_pr(:,:,1:15)=[];
c=access_npp(:,:,1:15); access_npp(:,:,1:15)=[];

de_tas1=cat(3,a,a,a,a,a,a); de_tas1(:,:,87:end)=[];
de_tas=cat(3,tmp,tmp,tmp,tmp,tmp,tmp); de_tas(:,:,87:end)=[];
de_pr1=cat(3,b,b,b,b,b,b); de_pr1(:,:,87:end)=[];
de_pr=cat(3,pre,pre,pre,pre,pre,pre); de_pr(:,:,87:end)=[];
de_npp1=cat(3,c,c,c,c,c,c); de_npp1(:,:,87:end)=[];
de_npp=cat(3,npp,npp,npp,npp,npp,npp); de_npp(:,:,87:end)=[];


for i=1:86
    a1=access_tas(:,:,i); b1=access_pr(:,:,i); c1=access_npp(:,:,i);
    access_tas(:,:,i)=mean(de_tas(:,:,1:15),3,'omitnan')+(a1-mean(de_tas1(:,:,1:15),3,'omitnan'));
    access_npp(:,:,i)=mean(de_npp(:,:,1:15),3,'omitnan')+(c1-mean(de_npp1(:,:,1:15),3,'omitnan'));
    access_pr(:,:,i)=mean(de_pr(:,:,1:15),3,'omitnan').*(b1./mean(de_pr1(:,:,1:15),3,'omitnan'));
end

load('/Volumes/TU200Pro/4 paper-C turnover/7.Physical protection/3.constrain_hamdi/1 changed_all/max_pre.mat','max_pre');

for i=1:86
    access_pr(:,:,i)=access_pr(:,:,i)/max_pre;
end

clay_01=clay_01+mask_tp; clay_01=clay_01(501:650,2501:2850);
bd_01=bd_01+mask_tp; bd_01=bd_01(501:650,2501:2850);

nu=52500;
fc=reshape(fc,[1,nu]);
sc=reshape(sc,[1,nu]);
fmrt=reshape(fmrt,[1,nu]);
smrt=reshape(smrt,[1,nu]);
pmrt=reshape(pmrt,[1,nu]);
grids_oc=reshape(grids_oc,[1,nu]);
clay_01=reshape(clay_01,[1,nu]);
bd_01=reshape(bd_01,[1,nu]);
mask_area2=reshape(mask_area1,[1,nu])*10^6;
bd_01=bd_01.*mask_area2/10;

for i=1:86
    hst(i,:)=reshape(access_tas(:,:,i),[1,nu]);
    hswc(i,:)=reshape(access_pr(:,:,i),[1,nu]);
    hfs(i,:)=reshape(access_npp(:,:,i),[1,nu]);
end

ctotal=grids_oc;
hcfs=ctotal.*fc; hcms=ctotal.*sc; hcss=ctotal.*(1-fc-sc);
mrt=cat(1,fmrt,smrt,pmrt,clay_01,bd_01);

path='/Users/shuairen/Desktop/ظԭ__/warming/';
load(strcat(path,'consPAR_TP.mat'));

load(strcat(path,'soc_spinup.mat'));
hcfs=mean(hfs_mo,1,'omitnan'); hcms=mean(hms_mo,1,'omitnan'); hcss=mean(hss_mo,1,'omitnan');

access_ssp585pre_hfs(1,:)=hcfs(1,:); access_ssp585pre_hms(1,:)=hcms(1,:); access_ssp585pre_hss(1,:)=hcss(1,:);

for j=1:nu
    cm_last(1,1)=hcfs(1,j); cm_last(2,1)=hcms(1,j); cm_last(3,1)=hcss(1,j);
    for i=1:86
        f_tem=had1(4,j)^((hst(i,j)-15)/10); s_tem=had1(5,j)^((hst(i,j)-15)/10); p_tem=had1(6,j)^((hst(i,j)-15)/10);
        f_moi=(hswc(i,j))^had1(3,j); s_moi=(hswc(i,j))^had1(3,j); p_moi=(hswc(i,j))^had1(3,j);
        if mrt(4,j)==0
            clay=1;
        elseif mrt(4,j)>0 && mrt(4,j)<0.033
            clay=1/(mrt(4,j)*19.6);
        elseif mrt(4,j)>0.033 || mrt(4,j)==0.033
            clay=1/(-2.13*mrt(4,j)^2+6.23*mrt(4,j)+0.55);
        else
            clay=nan;
        end
        
        f_app(i,j)=mrt(1,j)/(f_tem*f_moi*clay);
        if cm_last(1,1)>0
            s_in=cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(cm_last(1,1)+hfs(i,j))*had1(1,j);
            end
        else
            s_in=hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(hfs(i,j))*had1(1,j);
            end
        end
        s_res=s_in*10^14*7.05/(365*mrt(5,j));
        s_pri=1+((2.47*s_res)/(13.01+s_res));
        s_app(i,j)=mrt(2,j)/(s_tem*s_moi*clay)/s_pri;
        
        p_in=cm_last(2,1)*had1(2,j)/s_app(i,j);
        p_res=p_in*10^14*7.05/(365*mrt(5,j));
        p_pri=1+((2.47*p_res)/(13.01+p_res));
        
        p_app(i,j)=mrt(3,j)/(p_tem*p_moi*clay)/p_pri;
        
        if cm_last(1,1)>0
            cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+(cm_last(1,1)+hfs(i,j))*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        else
            cm_present(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        end
        
        %         cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
        %         cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had(1,j)/f_app(i,j);
        %         cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had(2,j)/s_app(i,j);
        
        cm_last=cm_present;
        access_ssp585pre_hfs(i+1,j)=cm_present(1,1); access_ssp585pre_hms(i+1,j)=cm_present(2,1); access_ssp585pre_hss(i+1,j)=cm_present(3,1);
    end
end

%     mask=mean(access_ssp585pre_hfs(end-10:end,:),1,'omitnan')./access_ssp585pre_hfs(1,:);
%     mask(mask==Inf)=0;load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histcs_stocks.mat','access_histcs_stocks');
%     mask(find(mask>100))=nan;
%     mask(mask>-100000)=0;

mask=access_ssp585pre_hfs(end,:)-access_ssp585pre_hfs(1,:); mask(mask>-10^100)=0;


%%% original C
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histcf_stocks.mat','access_histcf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histcm_stocks.mat','access_histcm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histcs_stocks.mat','access_histcs_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/ACCESS-ESM1-5/access_ssp585cf_stocks.mat','access_ssp585cf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/ACCESS-ESM1-5/access_ssp585cm_stocks.mat','access_ssp585cm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/ACCESS-ESM1-5/access_ssp585cs_stocks.mat','access_ssp585cs_stocks');
    
access_histcf_stocks(:,:,1:150)=[]; access_histcm_stocks(:,:,1:150)=[]; access_histcs_stocks(:,:,1:150)=[];
access_histcf_stocks=mean(access_histcf_stocks,3,'omitnan');
access_histcm_stocks=mean(access_histcm_stocks,3,'omitnan');
access_histcs_stocks=mean(access_histcs_stocks,3,'omitnan');
access_ssp585cf_stocks=cat(3,access_histcf_stocks,access_ssp585cf_stocks);
access_ssp585cm_stocks=cat(3,access_histcm_stocks,access_ssp585cm_stocks);
access_ssp585cs_stocks=cat(3,access_histcs_stocks,access_ssp585cs_stocks);

%%% pre-industrial temperature (1850-1900)
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histtas.mat','access_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/ACCESS-ESM1-5/access_ssp585tas.mat','access_ssp585tas');
access_histtas(:,:,51:end)=[]; access_histtas=mean(access_histtas,3,'omitnan');
access_ssp585tas=cat(3,access_histtas,access_ssp585tas);

for i=1:87
    cf=access_ssp585cf_stocks(:,:,i);
    cf=cf./mask_area;
    cf=imresample([deg_lo deg_la],cf,[0.0995,0.09935],'nearest');
    cf=cf.*area_01_km2;
    cf=cf(501:650,2501:2850);
    access_ssp585cf_orig(:,:,i)=cf;
    
    cm=access_ssp585cm_stocks(:,:,i);
    cm=cm./mask_area;
    cm=imresample([deg_lo deg_la],cm,[0.0995,0.09935],'nearest');
    cm=cm.*area_01_km2;
    cm=cm(501:650,2501:2850);
    access_ssp585cm_orig(:,:,i)=cm;
    
    cs=access_ssp585cs_stocks(:,:,i);
    cs=cs./mask_area;
    cs=imresample([deg_lo deg_la],cs,[0.0995,0.09935],'nearest');
    cs=cs.*area_01_km2;
    cs=cs(501:650,2501:2850);
    access_ssp585cs_orig(:,:,i)=cs;
end


for j=1:87
    f=access_ssp585pre_hfs(j,:);
    f=f+mask;
    f1=access_ssp585cf_orig(:,:,j);
    f1=reshape(f1,1,nu);
    f1=f1+mask;
    hfs1(j,1)=sum(f(:),'omitnan');
    hfs1(j,2)=sum(f1(:),'omitnan');
    
    m=access_ssp585pre_hms(j,:);
    m=m+mask;
    m1=access_ssp585cm_orig(:,:,j);
    m1=reshape(m1,1,nu);
    m1=m1+mask;
    hfs1(j,3)=sum(m(:),'omitnan');
    hfs1(j,4)=sum(m1(:),'omitnan');
    
    s=access_ssp585pre_hss(j,:);
    s=s+mask;
    s1=access_ssp585cs_orig(:,:,j);
    s1=reshape(s1,1,nu);
    s1=s1+mask;
    hfs1(j,5)=sum(s(:),'omitnan');
    hfs1(j,6)=sum(s1(:),'omitnan');
    
    to=f+m+s;
    to1=f1+m1+s1;
    hfs1(j,7)=sum(to(:),'omitnan');
    hfs1(j,8)=sum(to1(:),'omitnan');
    pre2(:,:,j)=reshape(to,150,350);
    ori2(:,:,j)=reshape(to1,150,350);
    pre_f(:,:,j)=reshape(f,150,350);
    pre_m(:,:,j)=reshape(m,150,350);
    pre_s(:,:,j)=reshape(s,150,350);
    
    t1=access_ssp585tas(:,:,j);
    hfs1(j,9)=mean(t1(:),'omitnan');
end


aa=hfs1(1,:);
for i=1:87
    hfs1(i,:)=hfs1(i,:)-aa;
end


yr=1:87;
plot(yr',hfs1(:,7));
hold on;
plot(yr',hfs1(:,8));

hfs1(:,9)=[];
hfs1= array2table(hfs1,...
    'VariableNames',{'pre_f','ori_f','pre_m','ori_m','pre_s','ori_s','pre_to','ori_to'});

path_out='/Users/shuairen/Desktop/ظԭ__/warming/ssp585/';


ssp585_accPRE_f=pre_f;
ssp585_accPRE_m=pre_m;
ssp585_accPRE_s=pre_s;

save(strcat(path_out,'ssp585_acc_pools.mat'), 'ssp585_accPRE_f','ssp585_accPRE_m','ssp585_accPRE_s');

% ssp585_accORI=ori2;
% ssp585_accPRE=pre2;
% save(strcat(path_out,'ssp585_acc.mat'), 'ssp585_accORI','ssp585_accPRE'); %%% modis and soilgrids
% writetable(hfs1,strcat(path_out,'ssp585_acc_yearly.csv'),'WriteRowNames',false);


%% ACCESS-ESM1-5; prediction-ssp245; constrain; use forѭ
clc;clear;
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histnpp_stocks.mat','access_histnpp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histtas.mat','access_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histpr.mat','access_histpr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/ACCESS-ESM1-5/access_ssp245npp_stocks.mat','access_ssp245npp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/ACCESS-ESM1-5/access_ssp245tas.mat','access_ssp245tas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/ACCESS-ESM1-5/access_ssp245pr.mat','access_ssp245pr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/2. ˮ/pre.mat');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/1. ¶/tmp.mat');
load('/Users/shuairen/Desktop/ظԭ__/warming/mask_tp.mat','mask_tp');

fc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fcp_tp_005.tif');
fc=double(fc); fc(fc<0)=nan;
sc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/scp_tp_005.tif');
sc=double(sc); sc(sc<0)=nan;
fmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fmrt_tp_005.tif');
fmrt=double(fmrt); fmrt(fmrt<0)=nan;
smrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/smrt_tp_005.tif');
smrt=double(smrt); smrt(smrt<0)=nan;
pmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/pmrt_tp_005.tif');
pmrt=double(pmrt); pmrt(pmrt<0)=nan;

fc=imresample([0.05,0.05],fc,[0.1,0.1],'nearest');
sc=imresample([0.05,0.05],sc,[0.1,0.1],'nearest');
fmrt=imresample([0.05,0.05],fmrt,[0.1,0.1],'nearest');
smrt=imresample([0.05,0.05],smrt,[0.1,0.1],'nearest');
pmrt=imresample([0.05,0.05],pmrt,[0.1,0.1],'nearest');


npp2000=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2000_TP_01.tif');
npp2001=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2001_TP_01.tif');
npp2002=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2002_TP_01.tif');
npp2003=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2003_TP_01.tif');
npp2004=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2004_TP_01.tif');
npp2005=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2005_TP_01.tif');
npp2006=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2006_TP_01.tif');
npp2007=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2007_TP_01.tif');
npp2008=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2008_TP_01.tif');
npp2009=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2009_TP_01.tif');
npp2010=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2010_TP_01.tif');
npp2011=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2011_TP_01.tif');
npp2012=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2012_TP_01.tif');
npp2013=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2013_TP_01.tif');
npp2014=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2014_TP_01.tif');
npp2015=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2015_TP_01.tif');

npp=cat(3,npp2000,npp2001,npp2002,npp2003,npp2004,npp2005,npp2006,npp2007,npp2008,npp2009,npp2010,npp2011,npp2012,npp2013,npp2014,npp2015);
npp=double(npp)/10; npp(npp>6500)=nan;
mask_fc=fc; mask_fc(mask_fc>0)=0;

for i=1:16
    npp(:,:,i)=npp(:,:,i)+mask_fc;
end

grids_oc=imread('/Users/shuairen/Desktop/ظԭ__/variables/socd/TP_1m_SOCD_kgCm2_01.tif');%%% λΪ kg/m2;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Clay content/clay_01.mat');
clay_01=mean(clay_01,3,'omitnan')/100;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Bulk density/bd_01.mat');
bd_01=mean(bd_01,3,'omitnan');

load('/Users/shuairen/Desktop/ظԭ__/warming/area_01_km2.mat','area_01_km2');
mask_area1=area_01_km2;
mask_area1=mask_area1+mask_tp; mask_area1=mask_area1(501:650,2501:2850);

grids_oc=(grids_oc.*mask_area1)/(10^6);


for i=1:16
    npp(:,:,i)=(npp(:,:,i).*mask_area1)*10^6/(10^15);
end
npp(:,:,end)=[];


pre(:,:,[1:99 115:end])=[]; tmp(:,:,[1:99 115:end])=[];%%%% 2000-2015
pre=imresample([0.5,0.5],pre,[0.09987,0.09976],'nearest'); tmp=imresample([0.5,0.5],tmp,[0.09987,0.09976],'nearest');

for i=1:15
    pre(:,:,i)=pre(:,:,i)+mask_tp;
    tmp(:,:,i)=tmp(:,:,i)+mask_tp;
end

tmp=tmp(501:650,2501:2850,:);
pre=pre(501:650,2501:2850,:);


access_histnpp_stocks(:,:,1:150)=[]; access_histpr(:,:,1:150)=[]; access_histtas(:,:,1:150)=[];
access_npp1=cat(3,access_histnpp_stocks,access_ssp245npp_stocks);
access_pr1=cat(3,access_histpr,access_ssp245pr);
access_tas1=cat(3,access_histtas,access_ssp245tas);


%%%% delta method
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/mask_area.mat','mask_area');
deg_lo=360/192; deg_la=180/145;

for i=1:101
    st=access_tas1(:,:,i);
    st=imresample([deg_lo deg_la],st,[0.0995,0.09935],'nearest');
    st=st+mask_tp; st=st(501:650,2501:2850);
    access_tas(:,:,i)=st;
    
    pr=access_pr1(:,:,i);
    pr=imresample([deg_lo deg_la],pr,[0.0995,0.09935],'nearest');
    pr=pr+mask_tp; pr=pr(501:650,2501:2850);
    access_pr(:,:,i)=pr;
    
    fvs=access_npp1(:,:,i);
    fvs=fvs./mask_area;
    fvs=imresample([deg_lo deg_la],fvs,[0.0995,0.09935],'nearest');
    fvs=fvs.*area_01_km2;
    fvs=fvs+mask_tp; fvs=fvs(501:650,2501:2850);
    access_npp(:,:,i)=fvs;
end


a=access_tas(:,:,1:15); access_tas(:,:,1:15)=[];
b=access_pr(:,:,1:15); access_pr(:,:,1:15)=[];
c=access_npp(:,:,1:15); access_npp(:,:,1:15)=[];

de_tas1=cat(3,a,a,a,a,a,a); de_tas1(:,:,87:end)=[];
de_tas=cat(3,tmp,tmp,tmp,tmp,tmp,tmp); de_tas(:,:,87:end)=[];
de_pr1=cat(3,b,b,b,b,b,b); de_pr1(:,:,87:end)=[];
de_pr=cat(3,pre,pre,pre,pre,pre,pre); de_pr(:,:,87:end)=[];
de_npp1=cat(3,c,c,c,c,c,c); de_npp1(:,:,87:end)=[];
de_npp=cat(3,npp,npp,npp,npp,npp,npp); de_npp(:,:,87:end)=[];


for i=1:86
    a1=access_tas(:,:,i); b1=access_pr(:,:,i); c1=access_npp(:,:,i);
    access_tas(:,:,i)=mean(de_tas(:,:,1:15),3,'omitnan')+(a1-mean(de_tas1(:,:,1:15),3,'omitnan'));
    access_npp(:,:,i)=mean(de_npp(:,:,1:15),3,'omitnan')+(c1-mean(de_npp1(:,:,1:15),3,'omitnan'));
    access_pr(:,:,i)=mean(de_pr(:,:,1:15),3,'omitnan').*(b1./mean(de_pr1(:,:,1:15),3,'omitnan'));
end

load('/Volumes/TU200Pro/4 paper-C turnover/7.Physical protection/3.constrain_hamdi/1 changed_all/max_pre.mat','max_pre');

for i=1:86
    access_pr(:,:,i)=access_pr(:,:,i)/max_pre;
end

clay_01=clay_01+mask_tp; clay_01=clay_01(501:650,2501:2850);
bd_01=bd_01+mask_tp; bd_01=bd_01(501:650,2501:2850);

nu=52500;
fc=reshape(fc,[1,nu]);
sc=reshape(sc,[1,nu]);
fmrt=reshape(fmrt,[1,nu]);
smrt=reshape(smrt,[1,nu]);
pmrt=reshape(pmrt,[1,nu]);
grids_oc=reshape(grids_oc,[1,nu]);
clay_01=reshape(clay_01,[1,nu]);
bd_01=reshape(bd_01,[1,nu]);
mask_area2=reshape(mask_area1,[1,nu])*10^6;
bd_01=bd_01.*mask_area2/10;

for i=1:86
    hst(i,:)=reshape(access_tas(:,:,i),[1,nu]);
    hswc(i,:)=reshape(access_pr(:,:,i),[1,nu]);
    hfs(i,:)=reshape(access_npp(:,:,i),[1,nu]);
end

ctotal=grids_oc;
hcfs=ctotal.*fc; hcms=ctotal.*sc; hcss=ctotal.*(1-fc-sc);
mrt=cat(1,fmrt,smrt,pmrt,clay_01,bd_01);

path='/Users/shuairen/Desktop/ظԭ__/warming/';
load(strcat(path,'consPAR_TP.mat'));

load(strcat(path,'soc_spinup.mat'));
hcfs=mean(hfs_mo,1,'omitnan'); hcms=mean(hms_mo,1,'omitnan'); hcss=mean(hss_mo,1,'omitnan');

access_ssp245pre_hfs(1,:)=hcfs(1,:); access_ssp245pre_hms(1,:)=hcms(1,:); access_ssp245pre_hss(1,:)=hcss(1,:);

for j=1:nu
    cm_last(1,1)=hcfs(1,j); cm_last(2,1)=hcms(1,j); cm_last(3,1)=hcss(1,j);
    for i=1:86
        f_tem=had1(4,j)^((hst(i,j)-15)/10); s_tem=had1(5,j)^((hst(i,j)-15)/10); p_tem=had1(6,j)^((hst(i,j)-15)/10);
        f_moi=(hswc(i,j))^had1(3,j); s_moi=(hswc(i,j))^had1(3,j); p_moi=(hswc(i,j))^had1(3,j);
        if mrt(4,j)==0
            clay=1;
        elseif mrt(4,j)>0 && mrt(4,j)<0.033
            clay=1/(mrt(4,j)*19.6);
        elseif mrt(4,j)>0.033 || mrt(4,j)==0.033
            clay=1/(-2.13*mrt(4,j)^2+6.23*mrt(4,j)+0.55);
        else
            clay=nan;
        end
        
        f_app(i,j)=mrt(1,j)/(f_tem*f_moi*clay);
        if cm_last(1,1)>0
            s_in=cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(cm_last(1,1)+hfs(i,j))*had1(1,j);
            end
        else
            s_in=hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(hfs(i,j))*had1(1,j);
            end
        end
        s_res=s_in*10^14*7.05/(365*mrt(5,j));
        s_pri=1+((2.47*s_res)/(13.01+s_res));
        s_app(i,j)=mrt(2,j)/(s_tem*s_moi*clay)/s_pri;
        
        p_in=cm_last(2,1)*had1(2,j)/s_app(i,j);
        p_res=p_in*10^14*7.05/(365*mrt(5,j));
        p_pri=1+((2.47*p_res)/(13.01+p_res));
        
        p_app(i,j)=mrt(3,j)/(p_tem*p_moi*clay)/p_pri;
        
        if cm_last(1,1)>0
            cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+(cm_last(1,1)+hfs(i,j))*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        else
            cm_present(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        end
        
        %         cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
        %         cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had(1,j)/f_app(i,j);
        %         cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had(2,j)/s_app(i,j);
        
        cm_last=cm_present;
        access_ssp245pre_hfs(i+1,j)=cm_present(1,1); access_ssp245pre_hms(i+1,j)=cm_present(2,1); access_ssp245pre_hss(i+1,j)=cm_present(3,1);
    end
end

%     mask=mean(access_ssp245pre_hfs(end-10:end,:),1,'omitnan')./access_ssp245pre_hfs(1,:);
%     mask(mask==Inf)=0;load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histcs_stocks.mat','access_histcs_stocks');
%     mask(find(mask>100))=nan;
%     mask(mask>-100000)=0;

mask=access_ssp245pre_hfs(end,:)-access_ssp245pre_hfs(1,:); mask(mask>-10^100)=0;


%%% original C
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histcf_stocks.mat','access_histcf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histcm_stocks.mat','access_histcm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histcs_stocks.mat','access_histcs_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/ACCESS-ESM1-5/access_ssp245cf_stocks.mat','access_ssp245cf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/ACCESS-ESM1-5/access_ssp245cm_stocks.mat','access_ssp245cm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/ACCESS-ESM1-5/access_ssp245cs_stocks.mat','access_ssp245cs_stocks');
    
access_histcf_stocks(:,:,1:150)=[]; access_histcm_stocks(:,:,1:150)=[]; access_histcs_stocks(:,:,1:150)=[];
access_histcf_stocks=mean(access_histcf_stocks,3,'omitnan');
access_histcm_stocks=mean(access_histcm_stocks,3,'omitnan');
access_histcs_stocks=mean(access_histcs_stocks,3,'omitnan');
access_ssp245cf_stocks=cat(3,access_histcf_stocks,access_ssp245cf_stocks);
access_ssp245cm_stocks=cat(3,access_histcm_stocks,access_ssp245cm_stocks);
access_ssp245cs_stocks=cat(3,access_histcs_stocks,access_ssp245cs_stocks);

%%% pre-industrial temperature (1850-1900)
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/ACCESS-ESM1-5/access_histtas.mat','access_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/ACCESS-ESM1-5/access_ssp245tas.mat','access_ssp245tas');
access_histtas(:,:,51:end)=[]; access_histtas=mean(access_histtas,3,'omitnan');
access_ssp245tas=cat(3,access_histtas,access_ssp245tas);

for i=1:87
    cf=access_ssp245cf_stocks(:,:,i);
    cf=cf./mask_area;
    cf=imresample([deg_lo deg_la],cf,[0.0995,0.09935],'nearest');
    cf=cf.*area_01_km2;
    cf=cf(501:650,2501:2850);
    access_ssp245cf_orig(:,:,i)=cf;
    
    cm=access_ssp245cm_stocks(:,:,i);
    cm=cm./mask_area;
    cm=imresample([deg_lo deg_la],cm,[0.0995,0.09935],'nearest');
    cm=cm.*area_01_km2;
    cm=cm(501:650,2501:2850);
    access_ssp245cm_orig(:,:,i)=cm;
    
    cs=access_ssp245cs_stocks(:,:,i);
    cs=cs./mask_area;
    cs=imresample([deg_lo deg_la],cs,[0.0995,0.09935],'nearest');
    cs=cs.*area_01_km2;
    cs=cs(501:650,2501:2850);
    access_ssp245cs_orig(:,:,i)=cs;
end


for j=1:87
    f=access_ssp245pre_hfs(j,:);
    f=f+mask;
    f1=access_ssp245cf_orig(:,:,j);
    f1=reshape(f1,1,nu);
    f1=f1+mask;
    hfs1(j,1)=sum(f(:),'omitnan');
    hfs1(j,2)=sum(f1(:),'omitnan');
    
    m=access_ssp245pre_hms(j,:);
    m=m+mask;
    m1=access_ssp245cm_orig(:,:,j);
    m1=reshape(m1,1,nu);
    m1=m1+mask;
    hfs1(j,3)=sum(m(:),'omitnan');
    hfs1(j,4)=sum(m1(:),'omitnan');
    
    s=access_ssp245pre_hss(j,:);
    s=s+mask;
    s1=access_ssp245cs_orig(:,:,j);
    s1=reshape(s1,1,nu);
    s1=s1+mask;
    hfs1(j,5)=sum(s(:),'omitnan');
    hfs1(j,6)=sum(s1(:),'omitnan');
    
    to=f+m+s;
    to1=f1+m1+s1;
    hfs1(j,7)=sum(to(:),'omitnan');
    hfs1(j,8)=sum(to1(:),'omitnan');
    pre2(:,:,j)=reshape(to,150,350);
    ori2(:,:,j)=reshape(to1,150,350);
    pre_f(:,:,j)=reshape(f,150,350);
    pre_m(:,:,j)=reshape(m,150,350);
    pre_s(:,:,j)=reshape(s,150,350);
    
    t1=access_ssp245tas(:,:,j);
    hfs1(j,9)=mean(t1(:),'omitnan');
end


aa=hfs1(1,:);
for i=1:87
    hfs1(i,:)=hfs1(i,:)-aa;
end


yr=1:87;
plot(yr',hfs1(:,7));
hold on;
plot(yr',hfs1(:,8));

hfs1(:,9)=[];
hfs1= array2table(hfs1,...
    'VariableNames',{'pre_f','ori_f','pre_m','ori_m','pre_s','ori_s','pre_to','ori_to'});

path_out='/Users/shuairen/Desktop/ظԭ__/warming/ssp245/';


ssp245_accPRE_f=pre_f;
ssp245_accPRE_m=pre_m;
ssp245_accPRE_s=pre_s;

save(strcat(path_out,'ssp245_acc_pools.mat'), 'ssp245_accPRE_f','ssp245_accPRE_m','ssp245_accPRE_s');

% ssp245_accORI=ori2;
% ssp245_accPRE=pre2;
% save(strcat(path_out,'ssp245_acc.mat'), 'ssp245_accORI','ssp245_accPRE'); %%% modis and soilgrids
% writetable(hfs1,strcat(path_out,'ssp245_acc_yearly.csv'),'WriteRowNames',false);



%% CESM2-WACCM; prediction-ssp585; constrain; use for ѭ
clc;clear;
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histnpp_stocks.mat','cesm2_histnpp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histtas.mat','cesm2_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histpr.mat','cesm2_histpr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/CESM2-WACCM/cesm2_ssp585npp_stocks.mat','cesm2_ssp585npp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/CESM2-WACCM/cesm2_ssp585tas.mat','cesm2_ssp585tas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/CESM2-WACCM/cesm2_ssp585pr.mat','cesm2_ssp585pr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/2. ˮ/pre.mat');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/1. ¶/tmp.mat');
load('/Users/shuairen/Desktop/ظԭ__/warming/mask_tp.mat','mask_tp');

fc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fcp_tp_005.tif');
fc=double(fc); fc(fc<0)=nan;
sc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/scp_tp_005.tif');
sc=double(sc); sc(sc<0)=nan;
fmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fmrt_tp_005.tif');
fmrt=double(fmrt); fmrt(fmrt<0)=nan;
smrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/smrt_tp_005.tif');
smrt=double(smrt); smrt(smrt<0)=nan;
pmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/pmrt_tp_005.tif');
pmrt=double(pmrt); pmrt(pmrt<0)=nan;

fc=imresample([0.05,0.05],fc,[0.1,0.1],'nearest');
sc=imresample([0.05,0.05],sc,[0.1,0.1],'nearest');
fmrt=imresample([0.05,0.05],fmrt,[0.1,0.1],'nearest');
smrt=imresample([0.05,0.05],smrt,[0.1,0.1],'nearest');
pmrt=imresample([0.05,0.05],pmrt,[0.1,0.1],'nearest');


npp2000=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2000_TP_01.tif');
npp2001=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2001_TP_01.tif');
npp2002=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2002_TP_01.tif');
npp2003=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2003_TP_01.tif');
npp2004=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2004_TP_01.tif');
npp2005=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2005_TP_01.tif');
npp2006=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2006_TP_01.tif');
npp2007=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2007_TP_01.tif');
npp2008=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2008_TP_01.tif');
npp2009=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2009_TP_01.tif');
npp2010=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2010_TP_01.tif');
npp2011=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2011_TP_01.tif');
npp2012=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2012_TP_01.tif');
npp2013=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2013_TP_01.tif');
npp2014=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2014_TP_01.tif');
npp2015=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2015_TP_01.tif');

npp=cat(3,npp2000,npp2001,npp2002,npp2003,npp2004,npp2005,npp2006,npp2007,npp2008,npp2009,npp2010,npp2011,npp2012,npp2013,npp2014,npp2015);
npp=double(npp)/10; npp(npp>6500)=nan;
mask_fc=fc; mask_fc(mask_fc>0)=0;

for i=1:16
    npp(:,:,i)=npp(:,:,i)+mask_fc;
end


grids_oc=imread('/Users/shuairen/Desktop/ظԭ__/variables/socd/TP_1m_SOCD_kgCm2_01.tif');%%% λΪ kg/m2;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Clay content/clay_01.mat');
clay_01=mean(clay_01,3,'omitnan')/100;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Bulk density/bd_01.mat');
bd_01=mean(bd_01,3,'omitnan');

load('/Users/shuairen/Desktop/ظԭ__/warming/area_01_km2.mat','area_01_km2');
mask_area1=area_01_km2;
mask_area1=mask_area1+mask_tp; mask_area1=mask_area1(501:650,2501:2850);

grids_oc=(grids_oc.*mask_area1)/(10^6);


for i=1:16
    npp(:,:,i)=(npp(:,:,i).*mask_area1)*10^6/(10^15);
end
npp(:,:,end)=[];


pre(:,:,[1:99 115:end])=[]; tmp(:,:,[1:99 115:end])=[];%%%% 2000-2015
pre=imresample([0.5,0.5],pre,[0.09987,0.09976],'nearest'); tmp=imresample([0.5,0.5],tmp,[0.09987,0.09976],'nearest');

for i=1:15
    pre(:,:,i)=pre(:,:,i)+mask_tp;
    tmp(:,:,i)=tmp(:,:,i)+mask_tp;
end

tmp=tmp(501:650,2501:2850,:);
pre=pre(501:650,2501:2850,:);


cesm2_histnpp_stocks(:,:,1:150)=[];cesm2_histpr(:,:,1:150)=[]; cesm2_histtas(:,:,1:150)=[];
cesm2_npp1=cat(3,cesm2_histnpp_stocks,cesm2_ssp585npp_stocks);
cesm2_pr1=cat(3,cesm2_histpr,cesm2_ssp585pr);
cesm2_tas1=cat(3,cesm2_histtas,cesm2_ssp585tas);

%%%% delta method
load('/Volumes/TU200Pro/4 paper-C turnover/2./ccsm4_mask_area.mat','mask_area');
deg_lo=360/288; deg_la=180/192;
for i=1:101
    st=cesm2_tas1(:,:,i);
    st=imresample([deg_lo deg_la],st,[0.09966,0.0995],'nearest');
    st=st+mask_tp; st=st(501:650,2501:2850);
    cesm2_tas(:,:,i)=st;
    
    pr=cesm2_pr1(:,:,i);
    pr=imresample([deg_lo deg_la],pr,[0.09966,0.0995],'nearest');
    pr=pr+mask_tp; pr=pr(501:650,2501:2850);
    cesm2_pr(:,:,i)=pr;
    
    fvs=cesm2_npp1(:,:,i);
    fvs=fvs./mask_area;
    fvs=imresample([deg_lo deg_la],fvs,[0.09966,0.0995],'nearest');
    fvs=fvs.*area_01_km2;
    fvs=fvs+mask_tp; fvs=fvs(501:650,2501:2850);
    cesm2_npp(:,:,i)=fvs;
end


a=cesm2_tas(:,:,1:15); cesm2_tas(:,:,1:15)=[];
b=cesm2_pr(:,:,1:15); cesm2_pr(:,:,1:15)=[];
c=cesm2_npp(:,:,1:15); cesm2_npp(:,:,1:15)=[];


de_tas1=cat(3,a,a,a,a,a,a); de_tas1(:,:,87:end)=[];
de_tas=cat(3,tmp,tmp,tmp,tmp,tmp,tmp); de_tas(:,:,87:end)=[];
de_pr1=cat(3,b,b,b,b,b,b); de_pr1(:,:,87:end)=[];
de_pr=cat(3,pre,pre,pre,pre,pre,pre); de_pr(:,:,87:end)=[];
de_npp1=cat(3,c,c,c,c,c,c); de_npp1(:,:,87:end)=[];
de_npp=cat(3,npp,npp,npp,npp,npp,npp); de_npp(:,:,87:end)=[];


for i=1:86
    a1=cesm2_tas(:,:,i); b1=cesm2_pr(:,:,i); c1=cesm2_npp(:,:,i);
    cesm2_tas(:,:,i)=mean(de_tas(:,:,1:15),3,'omitnan')+(a1-mean(de_tas1(:,:,1:15),3,'omitnan'));
    cesm2_pr(:,:,i)=mean(de_pr(:,:,1:15),3,'omitnan').*(b1./mean(de_pr1(:,:,1:15),3,'omitnan'));
    cesm2_npp(:,:,i)=mean(de_npp(:,:,1:15),3,'omitnan')+(c1-mean(de_npp1(:,:,1:15),3,'omitnan'));
    
end

load('/Volumes/TU200Pro/4 paper-C turnover/7.Physical protection/3.constrain_hamdi/1 changed_all/max_pre.mat','max_pre');

for i=1:86
    cesm2_pr(:,:,i)=cesm2_pr(:,:,i)/max_pre;
end

clay_01=clay_01+mask_tp; clay_01=clay_01(501:650,2501:2850);
bd_01=bd_01+mask_tp; bd_01=bd_01(501:650,2501:2850);

nu=52500;

fc=reshape(fc,[1,nu]);
sc=reshape(sc,[1,nu]);
fmrt=reshape(fmrt,[1,nu]);
smrt=reshape(smrt,[1,nu]);
pmrt=reshape(pmrt,[1,nu]);
grids_oc=reshape(grids_oc,[1,nu]);
clay_01=reshape(clay_01,[1,nu]);
bd_01=reshape(bd_01,[1,nu]);
mask_area2=reshape(mask_area1,[1,nu])*10^6;
bd_01=bd_01.*mask_area2/10;

for i=1:86
    hst(i,:)=reshape(cesm2_tas(:,:,i),[1,nu]);
    hswc(i,:)=reshape(cesm2_pr(:,:,i),[1,nu]);
    hfs(i,:)=reshape(cesm2_npp(:,:,i),[1,nu]);
end

ctotal=grids_oc;
hcfs=ctotal.*fc; hcms=ctotal.*sc; hcss=ctotal.*(1-fc-sc);
mrt=cat(1,fmrt,smrt,pmrt,clay_01,bd_01);


path='/Users/shuairen/Desktop/ظԭ__/warming/';
load(strcat(path,'consPAR_TP.mat'));
load(strcat(path,'soc_spinup.mat'));

hcfs=mean(hfs_mo,1,'omitnan'); hcms=mean(hms_mo,1,'omitnan'); hcss=mean(hss_mo,1,'omitnan');

cesm2_ssp585pre_hfs(1,:)=hcfs(1,:); cesm2_ssp585pre_hms(1,:)=hcms(1,:); cesm2_ssp585pre_hss(1,:)=hcss(1,:);

for j=1:nu
    cm_last(1,1)=hcfs(1,j); cm_last(2,1)=hcms(1,j); cm_last(3,1)=hcss(1,j);
    for i=1:86
        f_tem=had1(4,j)^((hst(i,j)-15)/10); s_tem=had1(5,j)^((hst(i,j)-15)/10); p_tem=had1(6,j)^((hst(i,j)-15)/10);
        f_moi=(hswc(i,j))^had1(3,j); s_moi=(hswc(i,j))^had1(3,j); p_moi=(hswc(i,j))^had1(3,j);
        if mrt(4,j)==0
            clay=1;
        elseif mrt(4,j)>0 && mrt(4,j)<0.033
            clay=1/(mrt(4,j)*19.6);
        elseif mrt(4,j)>0.033 || mrt(4,j)==0.033
            clay=1/(-2.13*mrt(4,j)^2+6.23*mrt(4,j)+0.55);
        else
            clay=nan;
        end
        
        f_app(i,j)=mrt(1,j)/(f_tem*f_moi*clay);
        if cm_last(1,1)>0
            s_in=cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(cm_last(1,1)+hfs(i,j))*had1(1,j);
            end
        else
            s_in=hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(hfs(i,j))*had1(1,j);
            end
        end
        s_res=s_in*10^14*7.05/(365*mrt(5,j));
        s_pri=1+((2.47*s_res)/(13.01+s_res));
        s_app(i,j)=mrt(2,j)/(s_tem*s_moi*clay)/s_pri;
        
        p_in=cm_last(2,1)*had1(2,j)/s_app(i,j);
        p_res=p_in*10^14*7.05/(365*mrt(5,j));
        p_pri=1+((2.47*p_res)/(13.01+p_res));
        
        p_app(i,j)=mrt(3,j)/(p_tem*p_moi*clay)/p_pri;
        
        if cm_last(1,1)>0
            cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+(cm_last(1,1)+hfs(i,j))*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        else
            cm_present(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        end
        
        %         cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
        %         cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had(1,j)/f_app(i,j);
        %         cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had(2,j)/s_app(i,j);
        
        cm_last=cm_present;
        cesm2_ssp585pre_hfs(i+1,j)=cm_present(1,1); cesm2_ssp585pre_hms(i+1,j)=cm_present(2,1); cesm2_ssp585pre_hss(i+1,j)=cm_present(3,1);
    end
end


mask=cesm2_ssp585pre_hfs(end,:)-cesm2_ssp585pre_hfs(1,:); mask(mask>-10^100)=0;

%%% original C
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histcf_stocks.mat','cesm2_histcf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histcm_stocks.mat','cesm2_histcm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histcs_stocks.mat','cesm2_histcs_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/CESM2-WACCM/cesm2_ssp585cf_stocks.mat','cesm2_ssp585cf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/CESM2-WACCM/cesm2_ssp585cm_stocks.mat','cesm2_ssp585cm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/CESM2-WACCM/cesm2_ssp585cs_stocks.mat','cesm2_ssp585cs_stocks');
    
cesm2_histcf_stocks(:,:,1:150)=[]; cesm2_histcm_stocks(:,:,1:150)=[]; cesm2_histcs_stocks(:,:,1:150)=[];
cesm2_histcf_stocks=mean(cesm2_histcf_stocks,3,'omitnan');
cesm2_histcm_stocks=mean(cesm2_histcm_stocks,3,'omitnan');
cesm2_histcs_stocks=mean(cesm2_histcs_stocks,3,'omitnan');
cesm2_ssp585cf_stocks=cat(3,cesm2_histcf_stocks,cesm2_ssp585cf_stocks);
cesm2_ssp585cm_stocks=cat(3,cesm2_histcm_stocks,cesm2_ssp585cm_stocks);
cesm2_ssp585cs_stocks=cat(3,cesm2_histcs_stocks,cesm2_ssp585cs_stocks);

%%% pre-industrial temperature
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histtas.mat','cesm2_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/CESM2-WACCM/cesm2_ssp585tas.mat','cesm2_ssp585tas');
cesm2_histtas(:,:,51:end)=[]; cesm2_histtas=mean(cesm2_histtas,3,'omitnan');
cesm2_ssp585tas=cat(3,cesm2_histtas,cesm2_ssp585tas);

for i=1:87
    cf=cesm2_ssp585cf_stocks(:,:,i);
    cf=cf./mask_area;
    cf=imresample([deg_lo deg_la],cf,[0.09966,0.0995],'nearest');
    cf=cf.*area_01_km2;
    cf=cf(501:650,2501:2850);
    cesm2_ssp585cf_orig(:,:,i)=cf;
    cm=cesm2_ssp585cm_stocks(:,:,i);
    cm=cm./mask_area;
    cm=imresample([deg_lo deg_la],cm,[0.09966,0.0995],'nearest');
    cm=cm.*area_01_km2;
    cm=cm(501:650,2501:2850);
    cesm2_ssp585cm_orig(:,:,i)=cm;
    cs=cesm2_ssp585cs_stocks(:,:,i);
    cs=cs./mask_area;
    cs=imresample([deg_lo deg_la],cs,[0.09966,0.0995],'nearest');
    cs=cs.*area_01_km2;
    cs=cs(501:650,2501:2850);
    cesm2_ssp585cs_orig(:,:,i)=cs;
end


for j=1:87
    f=cesm2_ssp585pre_hfs(j,:);
    f=f+mask;
    f1=cesm2_ssp585cf_orig(:,:,j);
    f1=reshape(f1,1,nu);
    f1=f1+mask;
    hfs1(j,1)=sum(f(:),'omitnan');
    hfs1(j,2)=sum(f1(:),'omitnan');
    m=cesm2_ssp585pre_hms(j,:);
    m=m+mask;
    m1=cesm2_ssp585cm_orig(:,:,j);
    m1=reshape(m1,1,nu);
    m1=m1+mask;
    hfs1(j,3)=sum(m(:),'omitnan');
    hfs1(j,4)=sum(m1(:),'omitnan');
    s=cesm2_ssp585pre_hss(j,:);
    s=s+mask;
    s1=cesm2_ssp585cs_orig(:,:,j);
    s1=reshape(s1,1,nu);
    s1=s1+mask;
    hfs1(j,5)=sum(s(:),'omitnan');
    hfs1(j,6)=sum(s1(:),'omitnan');
    to=f+m+s;
    to1=f1+m1+s1;
    hfs1(j,7)=sum(to(:),'omitnan');
    hfs1(j,8)=sum(to1(:),'omitnan');
    pre2(:,:,j)=reshape(to,150,350);
    ori2(:,:,j)=reshape(to1,150,350);
    pre_f(:,:,j)=reshape(f,150,350);
    pre_m(:,:,j)=reshape(m,150,350);
    pre_s(:,:,j)=reshape(s,150,350);
    
    t1=cesm2_ssp585tas(:,:,j);
    hfs1(j,9)=mean(t1(:),'omitnan');
end

aa=hfs1(1,:);
for i=1:87
    hfs1(i,:)=hfs1(i,:)-aa;
end


yr=1:87;
plot(yr',hfs1(:,7));
hold on;
plot(yr',hfs1(:,8));

hfs1(:,9)=[];
hfs1= array2table(hfs1,...
    'VariableNames',{'pre_f','ori_f','pre_m','ori_m','pre_s','ori_s','pre_to','ori_to'});

path_out='/Users/shuairen/Desktop/ظԭ__/warming/ssp585/';

ssp585_cesm2PRE_f=pre_f;
ssp585_cesm2PRE_m=pre_m;
ssp585_cesm2PRE_s=pre_s;

save(strcat(path_out,'ssp585_cesm2_pools.mat'), 'ssp585_cesm2PRE_f','ssp585_cesm2PRE_m','ssp585_cesm2PRE_s');


% ssp585_cesm2ORI=ori2;
% ssp585_cesm2PRE=pre2;
% save(strcat(path_out,'ssp585_cesm2.mat'),'ssp585_cesm2ORI','ssp585_cesm2PRE'); %%% modis and soilgrids
% writetable(hfs1,strcat(path_out,'ssp585_cesm2_yearly.csv'),'WriteRowNames',false);



%% CESM2-WACCM; prediction-ssp245; constrain; use for ѭ
clc;clear;
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histnpp_stocks.mat','cesm2_histnpp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histtas.mat','cesm2_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histpr.mat','cesm2_histpr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/CESM2-WACCM/cesm2_ssp245npp_stocks.mat','cesm2_ssp245npp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/CESM2-WACCM/cesm2_ssp245tas.mat','cesm2_ssp245tas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/CESM2-WACCM/cesm2_ssp245pr.mat','cesm2_ssp245pr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/2. ˮ/pre.mat');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/1. ¶/tmp.mat');
load('/Users/shuairen/Desktop/ظԭ__/warming/mask_tp.mat','mask_tp');

fc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fcp_tp_005.tif');
fc=double(fc); fc(fc<0)=nan;
sc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/scp_tp_005.tif');
sc=double(sc); sc(sc<0)=nan;
fmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fmrt_tp_005.tif');
fmrt=double(fmrt); fmrt(fmrt<0)=nan;
smrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/smrt_tp_005.tif');
smrt=double(smrt); smrt(smrt<0)=nan;
pmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/pmrt_tp_005.tif');
pmrt=double(pmrt); pmrt(pmrt<0)=nan;

fc=imresample([0.05,0.05],fc,[0.1,0.1],'nearest');
sc=imresample([0.05,0.05],sc,[0.1,0.1],'nearest');
fmrt=imresample([0.05,0.05],fmrt,[0.1,0.1],'nearest');
smrt=imresample([0.05,0.05],smrt,[0.1,0.1],'nearest');
pmrt=imresample([0.05,0.05],pmrt,[0.1,0.1],'nearest');


npp2000=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2000_TP_01.tif');
npp2001=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2001_TP_01.tif');
npp2002=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2002_TP_01.tif');
npp2003=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2003_TP_01.tif');
npp2004=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2004_TP_01.tif');
npp2005=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2005_TP_01.tif');
npp2006=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2006_TP_01.tif');
npp2007=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2007_TP_01.tif');
npp2008=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2008_TP_01.tif');
npp2009=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2009_TP_01.tif');
npp2010=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2010_TP_01.tif');
npp2011=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2011_TP_01.tif');
npp2012=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2012_TP_01.tif');
npp2013=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2013_TP_01.tif');
npp2014=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2014_TP_01.tif');
npp2015=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2015_TP_01.tif');

npp=cat(3,npp2000,npp2001,npp2002,npp2003,npp2004,npp2005,npp2006,npp2007,npp2008,npp2009,npp2010,npp2011,npp2012,npp2013,npp2014,npp2015);
npp=double(npp)/10; npp(npp>6500)=nan;
mask_fc=fc; mask_fc(mask_fc>0)=0;

for i=1:16
    npp(:,:,i)=npp(:,:,i)+mask_fc;
end


grids_oc=imread('/Users/shuairen/Desktop/ظԭ__/variables/socd/TP_1m_SOCD_kgCm2_01.tif');%%% λΪ kg/m2;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Clay content/clay_01.mat');
clay_01=mean(clay_01,3,'omitnan')/100;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Bulk density/bd_01.mat');
bd_01=mean(bd_01,3,'omitnan');

load('/Users/shuairen/Desktop/ظԭ__/warming/area_01_km2.mat','area_01_km2');
mask_area1=area_01_km2;
mask_area1=mask_area1+mask_tp; mask_area1=mask_area1(501:650,2501:2850);

grids_oc=(grids_oc.*mask_area1)/(10^6);


for i=1:16
    npp(:,:,i)=(npp(:,:,i).*mask_area1)*10^6/(10^15);
end
npp(:,:,end)=[];


pre(:,:,[1:99 115:end])=[]; tmp(:,:,[1:99 115:end])=[];%%%% 2000-2015
pre=imresample([0.5,0.5],pre,[0.09987,0.09976],'nearest'); tmp=imresample([0.5,0.5],tmp,[0.09987,0.09976],'nearest');

for i=1:15
    pre(:,:,i)=pre(:,:,i)+mask_tp;
    tmp(:,:,i)=tmp(:,:,i)+mask_tp;
end

tmp=tmp(501:650,2501:2850,:);
pre=pre(501:650,2501:2850,:);


cesm2_histnpp_stocks(:,:,1:150)=[];cesm2_histpr(:,:,1:150)=[]; cesm2_histtas(:,:,1:150)=[];
cesm2_npp1=cat(3,cesm2_histnpp_stocks,cesm2_ssp245npp_stocks);
cesm2_pr1=cat(3,cesm2_histpr,cesm2_ssp245pr);
cesm2_tas1=cat(3,cesm2_histtas,cesm2_ssp245tas);

%%%% delta method
load('/Volumes/TU200Pro/4 paper-C turnover/2./ccsm4_mask_area.mat','mask_area');
deg_lo=360/288; deg_la=180/192;
for i=1:101
    st=cesm2_tas1(:,:,i);
    st=imresample([deg_lo deg_la],st,[0.09966,0.0995],'nearest');
    st=st+mask_tp; st=st(501:650,2501:2850);
    cesm2_tas(:,:,i)=st;
    
    pr=cesm2_pr1(:,:,i);
    pr=imresample([deg_lo deg_la],pr,[0.09966,0.0995],'nearest');
    pr=pr+mask_tp; pr=pr(501:650,2501:2850);
    cesm2_pr(:,:,i)=pr;
    
    fvs=cesm2_npp1(:,:,i);
    fvs=fvs./mask_area;
    fvs=imresample([deg_lo deg_la],fvs,[0.09966,0.0995],'nearest');
    fvs=fvs.*area_01_km2;
    fvs=fvs+mask_tp; fvs=fvs(501:650,2501:2850);
    cesm2_npp(:,:,i)=fvs;
end


a=cesm2_tas(:,:,1:15); cesm2_tas(:,:,1:15)=[];
b=cesm2_pr(:,:,1:15); cesm2_pr(:,:,1:15)=[];
c=cesm2_npp(:,:,1:15); cesm2_npp(:,:,1:15)=[];


de_tas1=cat(3,a,a,a,a,a,a); de_tas1(:,:,87:end)=[];
de_tas=cat(3,tmp,tmp,tmp,tmp,tmp,tmp); de_tas(:,:,87:end)=[];
de_pr1=cat(3,b,b,b,b,b,b); de_pr1(:,:,87:end)=[];
de_pr=cat(3,pre,pre,pre,pre,pre,pre); de_pr(:,:,87:end)=[];
de_npp1=cat(3,c,c,c,c,c,c); de_npp1(:,:,87:end)=[];
de_npp=cat(3,npp,npp,npp,npp,npp,npp); de_npp(:,:,87:end)=[];


for i=1:86
    a1=cesm2_tas(:,:,i); b1=cesm2_pr(:,:,i); c1=cesm2_npp(:,:,i);
    cesm2_tas(:,:,i)=mean(de_tas(:,:,1:15),3,'omitnan')+(a1-mean(de_tas1(:,:,1:15),3,'omitnan'));
    cesm2_pr(:,:,i)=mean(de_pr(:,:,1:15),3,'omitnan').*(b1./mean(de_pr1(:,:,1:15),3,'omitnan'));
    cesm2_npp(:,:,i)=mean(de_npp(:,:,1:15),3,'omitnan')+(c1-mean(de_npp1(:,:,1:15),3,'omitnan'));
    
end

load('/Volumes/TU200Pro/4 paper-C turnover/7.Physical protection/3.constrain_hamdi/1 changed_all/max_pre.mat','max_pre');

for i=1:86
    cesm2_pr(:,:,i)=cesm2_pr(:,:,i)/max_pre;
end

clay_01=clay_01+mask_tp; clay_01=clay_01(501:650,2501:2850);
bd_01=bd_01+mask_tp; bd_01=bd_01(501:650,2501:2850);

nu=52500;

fc=reshape(fc,[1,nu]);
sc=reshape(sc,[1,nu]);
fmrt=reshape(fmrt,[1,nu]);
smrt=reshape(smrt,[1,nu]);
pmrt=reshape(pmrt,[1,nu]);
grids_oc=reshape(grids_oc,[1,nu]);
clay_01=reshape(clay_01,[1,nu]);
bd_01=reshape(bd_01,[1,nu]);
mask_area2=reshape(mask_area1,[1,nu])*10^6;
bd_01=bd_01.*mask_area2/10;

for i=1:86
    hst(i,:)=reshape(cesm2_tas(:,:,i),[1,nu]);
    hswc(i,:)=reshape(cesm2_pr(:,:,i),[1,nu]);
    hfs(i,:)=reshape(cesm2_npp(:,:,i),[1,nu]);
end

ctotal=grids_oc;
hcfs=ctotal.*fc; hcms=ctotal.*sc; hcss=ctotal.*(1-fc-sc);
mrt=cat(1,fmrt,smrt,pmrt,clay_01,bd_01);


path='/Users/shuairen/Desktop/ظԭ__/warming/';
load(strcat(path,'consPAR_TP.mat'));
load(strcat(path,'soc_spinup.mat'));

hcfs=mean(hfs_mo,1,'omitnan'); hcms=mean(hms_mo,1,'omitnan'); hcss=mean(hss_mo,1,'omitnan');

cesm2_ssp245pre_hfs(1,:)=hcfs(1,:); cesm2_ssp245pre_hms(1,:)=hcms(1,:); cesm2_ssp245pre_hss(1,:)=hcss(1,:);

for j=1:nu
    cm_last(1,1)=hcfs(1,j); cm_last(2,1)=hcms(1,j); cm_last(3,1)=hcss(1,j);
    for i=1:86
        f_tem=had1(4,j)^((hst(i,j)-15)/10); s_tem=had1(5,j)^((hst(i,j)-15)/10); p_tem=had1(6,j)^((hst(i,j)-15)/10);
        f_moi=(hswc(i,j))^had1(3,j); s_moi=(hswc(i,j))^had1(3,j); p_moi=(hswc(i,j))^had1(3,j);
        if mrt(4,j)==0
            clay=1;
        elseif mrt(4,j)>0 && mrt(4,j)<0.033
            clay=1/(mrt(4,j)*19.6);
        elseif mrt(4,j)>0.033 || mrt(4,j)==0.033
            clay=1/(-2.13*mrt(4,j)^2+6.23*mrt(4,j)+0.55);
        else
            clay=nan;
        end
        
        f_app(i,j)=mrt(1,j)/(f_tem*f_moi*clay);
        if cm_last(1,1)>0
            s_in=cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(cm_last(1,1)+hfs(i,j))*had1(1,j);
            end
        else
            s_in=hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(hfs(i,j))*had1(1,j);
            end
        end
        s_res=s_in*10^14*7.05/(365*mrt(5,j));
        s_pri=1+((2.47*s_res)/(13.01+s_res));
        s_app(i,j)=mrt(2,j)/(s_tem*s_moi*clay)/s_pri;
        
        p_in=cm_last(2,1)*had1(2,j)/s_app(i,j);
        p_res=p_in*10^14*7.05/(365*mrt(5,j));
        p_pri=1+((2.47*p_res)/(13.01+p_res));
        
        p_app(i,j)=mrt(3,j)/(p_tem*p_moi*clay)/p_pri;
        
        if cm_last(1,1)>0
            cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+(cm_last(1,1)+hfs(i,j))*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        else
            cm_present(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        end
        
        %         cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
        %         cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had(1,j)/f_app(i,j);
        %         cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had(2,j)/s_app(i,j);
        
        cm_last=cm_present;
        cesm2_ssp245pre_hfs(i+1,j)=cm_present(1,1); cesm2_ssp245pre_hms(i+1,j)=cm_present(2,1); cesm2_ssp245pre_hss(i+1,j)=cm_present(3,1);
    end
end


mask=cesm2_ssp245pre_hfs(end,:)-cesm2_ssp245pre_hfs(1,:); mask(mask>-10^100)=0;

%%% original C
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histcf_stocks.mat','cesm2_histcf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histcm_stocks.mat','cesm2_histcm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histcs_stocks.mat','cesm2_histcs_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/CESM2-WACCM/cesm2_ssp245cf_stocks.mat','cesm2_ssp245cf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/CESM2-WACCM/cesm2_ssp245cm_stocks.mat','cesm2_ssp245cm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/CESM2-WACCM/cesm2_ssp245cs_stocks.mat','cesm2_ssp245cs_stocks');
    
cesm2_histcf_stocks(:,:,1:150)=[]; cesm2_histcm_stocks(:,:,1:150)=[]; cesm2_histcs_stocks(:,:,1:150)=[];
cesm2_histcf_stocks=mean(cesm2_histcf_stocks,3,'omitnan');
cesm2_histcm_stocks=mean(cesm2_histcm_stocks,3,'omitnan');
cesm2_histcs_stocks=mean(cesm2_histcs_stocks,3,'omitnan');
cesm2_ssp245cf_stocks=cat(3,cesm2_histcf_stocks,cesm2_ssp245cf_stocks);
cesm2_ssp245cm_stocks=cat(3,cesm2_histcm_stocks,cesm2_ssp245cm_stocks);
cesm2_ssp245cs_stocks=cat(3,cesm2_histcs_stocks,cesm2_ssp245cs_stocks);

%%% pre-industrial temperature
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/CESM2-WACCM/cesm2_histtas.mat','cesm2_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/CESM2-WACCM/cesm2_ssp245tas.mat','cesm2_ssp245tas');
cesm2_histtas(:,:,51:end)=[]; cesm2_histtas=mean(cesm2_histtas,3,'omitnan');
cesm2_ssp245tas=cat(3,cesm2_histtas,cesm2_ssp245tas);

for i=1:87
    cf=cesm2_ssp245cf_stocks(:,:,i);
    cf=cf./mask_area;
    cf=imresample([deg_lo deg_la],cf,[0.09966,0.0995],'nearest');
    cf=cf.*area_01_km2;
    cf=cf(501:650,2501:2850);
    cesm2_ssp245cf_orig(:,:,i)=cf;
    cm=cesm2_ssp245cm_stocks(:,:,i);
    cm=cm./mask_area;
    cm=imresample([deg_lo deg_la],cm,[0.09966,0.0995],'nearest');
    cm=cm.*area_01_km2;
    cm=cm(501:650,2501:2850);
    cesm2_ssp245cm_orig(:,:,i)=cm;
    cs=cesm2_ssp245cs_stocks(:,:,i);
    cs=cs./mask_area;
    cs=imresample([deg_lo deg_la],cs,[0.09966,0.0995],'nearest');
    cs=cs.*area_01_km2;
    cs=cs(501:650,2501:2850);
    cesm2_ssp245cs_orig(:,:,i)=cs;
end


for j=1:87
    f=cesm2_ssp245pre_hfs(j,:);
    f=f+mask;
    f1=cesm2_ssp245cf_orig(:,:,j);
    f1=reshape(f1,1,nu);
    f1=f1+mask;
    hfs1(j,1)=sum(f(:),'omitnan');
    hfs1(j,2)=sum(f1(:),'omitnan');
    m=cesm2_ssp245pre_hms(j,:);
    m=m+mask;
    m1=cesm2_ssp245cm_orig(:,:,j);
    m1=reshape(m1,1,nu);
    m1=m1+mask;
    hfs1(j,3)=sum(m(:),'omitnan');
    hfs1(j,4)=sum(m1(:),'omitnan');
    s=cesm2_ssp245pre_hss(j,:);
    s=s+mask;
    s1=cesm2_ssp245cs_orig(:,:,j);
    s1=reshape(s1,1,nu);
    s1=s1+mask;
    hfs1(j,5)=sum(s(:),'omitnan');
    hfs1(j,6)=sum(s1(:),'omitnan');
    to=f+m+s;
    to1=f1+m1+s1;
    hfs1(j,7)=sum(to(:),'omitnan');
    hfs1(j,8)=sum(to1(:),'omitnan');
    pre2(:,:,j)=reshape(to,150,350);
    ori2(:,:,j)=reshape(to1,150,350);
    pre_f(:,:,j)=reshape(f,150,350);
    pre_m(:,:,j)=reshape(m,150,350);
    pre_s(:,:,j)=reshape(s,150,350);
    
    t1=cesm2_ssp245tas(:,:,j);
    hfs1(j,9)=mean(t1(:),'omitnan');
end

aa=hfs1(1,:);
for i=1:87
    hfs1(i,:)=hfs1(i,:)-aa;
end


yr=1:87;
plot(yr',hfs1(:,7));
hold on;
plot(yr',hfs1(:,8));

hfs1(:,9)=[];
hfs1= array2table(hfs1,...
    'VariableNames',{'pre_f','ori_f','pre_m','ori_m','pre_s','ori_s','pre_to','ori_to'});

path_out='/Users/shuairen/Desktop/ظԭ__/warming/ssp245/';

ssp245_cesm2PRE_f=pre_f;
ssp245_cesm2PRE_m=pre_m;
ssp245_cesm2PRE_s=pre_s;

save(strcat(path_out,'ssp245_cesm2_pools.mat'), 'ssp245_cesm2PRE_f','ssp245_cesm2PRE_m','ssp245_cesm2PRE_s');


% ssp245_cesm2ORI=ori2;
% ssp245_cesm2PRE=pre2;
% save(strcat(path_out,'ssp245_cesm2.mat'),'ssp245_cesm2ORI','ssp245_cesm2PRE'); %%% modis and soilgrids
% writetable(hfs1,strcat(path_out,'ssp245_cesm2_yearly.csv'),'WriteRowNames',false);



%% IPSL-CM6A-LR; prediction-ssp585; constrain; use for ѭ
clc;clear;
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histnpp_stocks.mat','ipsl_histnpp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histtas.mat','ipsl_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histpr.mat','ipsl_histpr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/IPSL-CM6A-LR/ipsl_ssp585npp_stocks.mat','ipsl_ssp585npp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/IPSL-CM6A-LR/ipsl_ssp585tas.mat','ipsl_ssp585tas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/IPSL-CM6A-LR/ipsl_ssp585pr.mat','ipsl_ssp585pr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/2. ˮ/pre.mat');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/1. ¶/tmp.mat');
load('/Users/shuairen/Desktop/ظԭ__/warming/mask_tp.mat','mask_tp');

fc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fcp_tp_005.tif');
fc=double(fc); fc(fc<0)=nan;
sc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/scp_tp_005.tif');
sc=double(sc); sc(sc<0)=nan;
fmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fmrt_tp_005.tif');
fmrt=double(fmrt); fmrt(fmrt<0)=nan;
smrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/smrt_tp_005.tif');
smrt=double(smrt); smrt(smrt<0)=nan;
pmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/pmrt_tp_005.tif');
pmrt=double(pmrt); pmrt(pmrt<0)=nan;

fc=imresample([0.05,0.05],fc,[0.1,0.1],'nearest');
sc=imresample([0.05,0.05],sc,[0.1,0.1],'nearest');
fmrt=imresample([0.05,0.05],fmrt,[0.1,0.1],'nearest');
smrt=imresample([0.05,0.05],smrt,[0.1,0.1],'nearest');
pmrt=imresample([0.05,0.05],pmrt,[0.1,0.1],'nearest');


npp2000=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2000_TP_01.tif');
npp2001=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2001_TP_01.tif');
npp2002=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2002_TP_01.tif');
npp2003=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2003_TP_01.tif');
npp2004=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2004_TP_01.tif');
npp2005=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2005_TP_01.tif');
npp2006=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2006_TP_01.tif');
npp2007=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2007_TP_01.tif');
npp2008=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2008_TP_01.tif');
npp2009=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2009_TP_01.tif');
npp2010=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2010_TP_01.tif');
npp2011=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2011_TP_01.tif');
npp2012=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2012_TP_01.tif');
npp2013=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2013_TP_01.tif');
npp2014=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2014_TP_01.tif');
npp2015=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2015_TP_01.tif');

npp=cat(3,npp2000,npp2001,npp2002,npp2003,npp2004,npp2005,npp2006,npp2007,npp2008,npp2009,npp2010,npp2011,npp2012,npp2013,npp2014,npp2015);
npp=double(npp)/10; npp(npp>6500)=nan;
mask_fc=fc; mask_fc(mask_fc>0)=0;

for i=1:16
    npp(:,:,i)=npp(:,:,i)+mask_fc;
end

grids_oc=imread('/Users/shuairen/Desktop/ظԭ__/variables/socd/TP_1m_SOCD_kgCm2_01.tif');%%% λΪ kg/m2;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Clay content/clay_01.mat');
clay_01=mean(clay_01,3,'omitnan')/100;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Bulk density/bd_01.mat');
bd_01=mean(bd_01,3,'omitnan');

load('/Users/shuairen/Desktop/ظԭ__/warming/area_01_km2.mat','area_01_km2');
mask_area1=area_01_km2;
mask_area1=mask_area1+mask_tp; mask_area1=mask_area1(501:650,2501:2850);

grids_oc=(grids_oc.*mask_area1)/(10^6);


for i=1:16
    npp(:,:,i)=(npp(:,:,i).*mask_area1)*10^6/(10^15);
end
npp(:,:,end)=[];


pre(:,:,[1:99 115:end])=[]; tmp(:,:,[1:99 115:end])=[];%%%% 2000-2015
pre=imresample([0.5,0.5],pre,[0.09987,0.09976],'nearest'); tmp=imresample([0.5,0.5],tmp,[0.09987,0.09976],'nearest');

for i=1:15
    pre(:,:,i)=pre(:,:,i)+mask_tp;
    tmp(:,:,i)=tmp(:,:,i)+mask_tp;
end

tmp=tmp(501:650,2501:2850,:);
pre=pre(501:650,2501:2850,:);


ipsl_histnpp_stocks(:,:,1:150)=[]; ipsl_histpr(:,:,1:150)=[]; ipsl_histtas(:,:,1:150)=[];
ipsl_npp1=cat(3,ipsl_histnpp_stocks,ipsl_ssp585npp_stocks);
ipsl_pr1=cat(3,ipsl_histpr,ipsl_ssp585pr);
ipsl_tas1=cat(3,ipsl_histtas,ipsl_ssp585tas);

%%%% delta method
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/mask_area.mat','mask_area');
deg_lo=360/144; deg_la=180/143;
for i=1:101
    st=ipsl_tas1(:,:,i);
    st=imresample([deg_lo deg_la],st,[0.09933,0.09935],'nearest');
    st=st+mask_tp; st=st(501:650,2501:2850);
    ipsl_tas(:,:,i)=st;
    
    pr=ipsl_pr1(:,:,i);
    pr=imresample([deg_lo deg_la],pr,[0.09933,0.09935],'nearest');
    pr=pr+mask_tp; pr=pr(501:650,2501:2850);
    ipsl_pr(:,:,i)=pr;
    
    fvs=ipsl_npp1(:,:,i);
    fvs=fvs./mask_area;
    fvs=imresample([deg_lo deg_la],fvs,[0.09933,0.09935],'nearest');
    fvs=fvs.*area_01_km2;
    fvs=fvs+mask_tp; fvs=fvs(501:650,2501:2850);
    ipsl_npp(:,:,i)=fvs;
end


a=ipsl_tas(:,:,1:15); ipsl_tas(:,:,1:15)=[];
b=ipsl_pr(:,:,1:15); ipsl_pr(:,:,1:15)=[];
c=ipsl_npp(:,:,1:15); ipsl_npp(:,:,1:15)=[];


de_tas1=cat(3,a,a,a,a,a,a); de_tas1(:,:,87:end)=[];
de_tas=cat(3,tmp,tmp,tmp,tmp,tmp,tmp); de_tas(:,:,87:end)=[];
de_pr1=cat(3,b,b,b,b,b,b); de_pr1(:,:,87:end)=[];
de_pr=cat(3,pre,pre,pre,pre,pre,pre); de_pr(:,:,87:end)=[];
de_npp1=cat(3,c,c,c,c,c,c); de_npp1(:,:,87:end)=[];
de_npp=cat(3,npp,npp,npp,npp,npp,npp); de_npp(:,:,87:end)=[];

for i=1:86
    a1=ipsl_tas(:,:,i); b1=ipsl_pr(:,:,i); c1=ipsl_npp(:,:,i);
    ipsl_tas(:,:,i)=mean(de_tas(:,:,1:15),3,'omitnan')+(a1-mean(de_tas1(:,:,1:15),3,'omitnan'));
    ipsl_pr(:,:,i)=mean(de_pr(:,:,1:15),3,'omitnan').*(b1./mean(de_pr1(:,:,1:15),3,'omitnan'));
    ipsl_npp(:,:,i)=mean(de_npp(:,:,1:15),3,'omitnan')+(c1-mean(de_npp1(:,:,1:15),3,'omitnan'));
    
end

load('/Volumes/TU200Pro/4 paper-C turnover/7.Physical protection/3.constrain_hamdi/1 changed_all/max_pre.mat','max_pre');
for i=1:86
    ipsl_pr(:,:,i)=ipsl_pr(:,:,i)/max_pre;
end

clay_01=clay_01+mask_tp; clay_01=clay_01(501:650,2501:2850);
bd_01=bd_01+mask_tp; bd_01=bd_01(501:650,2501:2850);

nu=52500;

fc=reshape(fc,[1,nu]);
sc=reshape(sc,[1,nu]);
fmrt=reshape(fmrt,[1,nu]);
smrt=reshape(smrt,[1,nu]);
pmrt=reshape(pmrt,[1,nu]);
grids_oc=reshape(grids_oc,[1,nu]);
clay_01=reshape(clay_01,[1,nu]);
bd_01=reshape(bd_01,[1,nu]);
mask_area2=reshape(mask_area1,[1,nu])*10^6;
bd_01=bd_01.*mask_area2/10;

for i=1:86
    hst(i,:)=reshape(ipsl_tas(:,:,i),[1,nu]);
    hswc(i,:)=reshape(ipsl_pr(:,:,i),[1,nu]);
    hfs(i,:)=reshape(ipsl_npp(:,:,i),[1,nu]);
end

ctotal=grids_oc;
hcfs=ctotal.*fc; hcms=ctotal.*sc; hcss=ctotal.*(1-fc-sc);
mrt=cat(1,fmrt,smrt,pmrt,clay_01,bd_01);

path='/Users/shuairen/Desktop/ظԭ__/warming/';
load(strcat(path,'consPAR_TP.mat'));
load(strcat(path,'soc_spinup.mat'));

hcfs=mean(hfs_mo,1,'omitnan'); hcms=mean(hms_mo,1,'omitnan'); hcss=mean(hss_mo,1,'omitnan');
ipsl_ssp585pre_hfs(1,:)=hcfs(1,:); ipsl_ssp585pre_hms(1,:)=hcms(1,:); ipsl_ssp585pre_hss(1,:)=hcss(1,:);
for j=1:nu
    cm_last(1,1)=hcfs(1,j); cm_last(2,1)=hcms(1,j); cm_last(3,1)=hcss(1,j);
    for i=1:86
        f_tem=had1(4,j)^((hst(i,j)-15)/10); s_tem=had1(5,j)^((hst(i,j)-15)/10); p_tem=had1(6,j)^((hst(i,j)-15)/10);
        f_moi=(hswc(i,j))^had1(3,j); s_moi=(hswc(i,j))^had1(3,j); p_moi=(hswc(i,j))^had1(3,j);
        if mrt(4,j)==0
            clay=1;
        elseif mrt(4,j)>0 && mrt(4,j)<0.033
            clay=1/(mrt(4,j)*19.6);
        elseif mrt(4,j)>0.033 || mrt(4,j)==0.033
            clay=1/(-2.13*mrt(4,j)^2+6.23*mrt(4,j)+0.55);
        else
            clay=nan;
        end
        
        f_app(i,j)=mrt(1,j)/(f_tem*f_moi*clay);
        if cm_last(1,1)>0
            s_in=cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(cm_last(1,1)+hfs(i,j))*had1(1,j);
            end
        else
            s_in=hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(hfs(i,j))*had1(1,j);
            end
        end
        s_res=s_in*10^14*7.05/(365*mrt(5,j));
        s_pri=1+((2.47*s_res)/(13.01+s_res));
        s_app(i,j)=mrt(2,j)/(s_tem*s_moi*clay)/s_pri;
        
        p_in=cm_last(2,1)*had1(2,j)/s_app(i,j);
        p_res=p_in*10^14*7.05/(365*mrt(5,j));
        p_pri=1+((2.47*p_res)/(13.01+p_res));
        
        p_app(i,j)=mrt(3,j)/(p_tem*p_moi*clay)/p_pri;
        
        if cm_last(1,1)>0
            cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+(cm_last(1,1)+hfs(i,j))*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        else
            cm_present(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        end
        
        %         cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
        %         cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had(1,j)/f_app(i,j);
        %         cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had(2,j)/s_app(i,j);
        
        cm_last=cm_present;
        ipsl_ssp585pre_hfs(i+1,j)=cm_present(1,1); ipsl_ssp585pre_hms(i+1,j)=cm_present(2,1); ipsl_ssp585pre_hss(i+1,j)=cm_present(3,1);
    end
end


mask=ipsl_ssp585pre_hfs(end,:)-ipsl_ssp585pre_hfs(1,:); mask(mask>-10^100)=0;

%%% original C
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histcf_stocks.mat','ipsl_histcf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histcm_stocks.mat','ipsl_histcm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histcs_stocks.mat','ipsl_histcs_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/IPSL-CM6A-LR/ipsl_ssp585cf_stocks.mat','ipsl_ssp585cf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/IPSL-CM6A-LR/ipsl_ssp585cm_stocks.mat','ipsl_ssp585cm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/IPSL-CM6A-LR/ipsl_ssp585cs_stocks.mat','ipsl_ssp585cs_stocks');
    
ipsl_histcf_stocks(:,:,1:150)=[]; ipsl_histcm_stocks(:,:,1:150)=[]; ipsl_histcs_stocks(:,:,1:150)=[];
ipsl_histcf_stocks=mean(ipsl_histcf_stocks,3,'omitnan');
ipsl_histcm_stocks=mean(ipsl_histcm_stocks,3,'omitnan');
ipsl_histcs_stocks=mean(ipsl_histcs_stocks,3,'omitnan');
ipsl_ssp585cf_stocks=cat(3,ipsl_histcf_stocks,ipsl_ssp585cf_stocks);
ipsl_ssp585cm_stocks=cat(3,ipsl_histcm_stocks,ipsl_ssp585cm_stocks);
ipsl_ssp585cs_stocks=cat(3,ipsl_histcs_stocks,ipsl_ssp585cs_stocks);

%%% pre-industrial temperature
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histtas.mat','ipsl_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/IPSL-CM6A-LR/ipsl_ssp585tas.mat','ipsl_ssp585tas');
ipsl_histtas(:,:,51:end)=[]; ipsl_histtas=mean(ipsl_histtas,3,'omitnan');
ipsl_ssp585tas=cat(3,ipsl_histtas,ipsl_ssp585tas);

for i=1:87
    cf=ipsl_ssp585cf_stocks(:,:,i);
    cf=cf./mask_area;
    cf=imresample([deg_lo deg_la],cf,[0.09933,0.09935],'nearest');
    cf=cf.*area_01_km2;
    cf=cf(501:650,2501:2850);
    ipsl_ssp585cf_orig(:,:,i)=cf;
    
    cm=ipsl_ssp585cm_stocks(:,:,i);
    cm=cm./mask_area;
    cm=imresample([deg_lo deg_la],cm,[0.09933,0.09935],'nearest');
    cm=cm.*area_01_km2;
    cm=cm(501:650,2501:2850);
    ipsl_ssp585cm_orig(:,:,i)=cm;
    
    cs=ipsl_ssp585cs_stocks(:,:,i);
    cs=cs./mask_area;
    cs=imresample([deg_lo deg_la],cs,[0.09933,0.09935],'nearest');
    cs=cs.*area_01_km2;
    cs=cs(501:650,2501:2850);
    ipsl_ssp585cs_orig(:,:,i)=cs;
end


for j=1:87
    f=ipsl_ssp585pre_hfs(j,:);
    f=f+mask;
    f1=ipsl_ssp585cf_orig(:,:,j);
    f1=reshape(f1,1,nu);
    f1=f1+mask;
    hfs1(j,1)=sum(f(:),'omitnan');
    hfs1(j,2)=sum(f1(:),'omitnan');
    m=ipsl_ssp585pre_hms(j,:);
    m=m+mask;
    m1=ipsl_ssp585cm_orig(:,:,j);
    m1=reshape(m1,1,nu);
    m1=m1+mask;
    hfs1(j,3)=sum(m(:),'omitnan');
    hfs1(j,4)=sum(m1(:),'omitnan');
    s=ipsl_ssp585pre_hss(j,:);
    s=s+mask;
    s1=ipsl_ssp585cs_orig(:,:,j);
    s1=reshape(s1,1,nu);
    s1=s1+mask;
    hfs1(j,5)=sum(s(:),'omitnan');
    hfs1(j,6)=sum(s1(:),'omitnan');
    to=f+m+s;
    to1=f1+m1+s1;
    hfs1(j,7)=sum(to(:),'omitnan');
    hfs1(j,8)=sum(to1(:),'omitnan');
    pre2(:,:,j)=reshape(to,150,350);
    ori2(:,:,j)=reshape(to1,150,350);
    pre_f(:,:,j)=reshape(f,150,350);
pre_m(:,:,j)=reshape(m,150,350);
pre_s(:,:,j)=reshape(s,150,350);
    
    t1=ipsl_ssp585tas(:,:,j);
    hfs1(j,9)=mean(t1(:),'omitnan');
end

aa=hfs1(1,:);
for i=1:87
    hfs1(i,:)=hfs1(i,:)-aa;
end


yr=1:87;
plot(yr',hfs1(:,7));
hold on;
plot(yr',hfs1(:,8));

hfs1(:,9)=[];
hfs1= array2table(hfs1,...
    'VariableNames',{'pre_f','ori_f','pre_m','ori_m','pre_s','ori_s','pre_to','ori_to'});

path_out='/Users/shuairen/Desktop/ظԭ__/warming/ssp585/';

ssp585_ipslPRE_f=pre_f;
ssp585_ipslPRE_m=pre_m;
ssp585_ipslPRE_s=pre_s;

save(strcat(path_out,'ssp585_ipsl_pools.mat'), 'ssp585_ipslPRE_f','ssp585_ipslPRE_m','ssp585_ipslPRE_s');

% ssp585_ipslORI=ori2;
% ssp585_ipslPRE=pre2;
% save(strcat(path_out,'ssp585_ipsl.mat'),'ssp585_ipslORI','ssp585_ipslPRE'); %%% modis and soilgrids
% writetable(hfs1,strcat(path_out,'ssp585_ipsl_yearly.csv'),'WriteRowNames',false);



%% IPSL-CM6A-LR; prediction-ssp245; constrain; use for ѭ
clc;clear;
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histnpp_stocks.mat','ipsl_histnpp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histtas.mat','ipsl_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histpr.mat','ipsl_histpr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/IPSL-CM6A-LR/ipsl_ssp245npp_stocks.mat','ipsl_ssp245npp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/IPSL-CM6A-LR/ipsl_ssp245tas.mat','ipsl_ssp245tas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/IPSL-CM6A-LR/ipsl_ssp245pr.mat','ipsl_ssp245pr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/2. ˮ/pre.mat');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/1. ¶/tmp.mat');
load('/Users/shuairen/Desktop/ظԭ__/warming/mask_tp.mat','mask_tp');

fc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fcp_tp_005.tif');
fc=double(fc); fc(fc<0)=nan;
sc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/scp_tp_005.tif');
sc=double(sc); sc(sc<0)=nan;
fmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fmrt_tp_005.tif');
fmrt=double(fmrt); fmrt(fmrt<0)=nan;
smrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/smrt_tp_005.tif');
smrt=double(smrt); smrt(smrt<0)=nan;
pmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/pmrt_tp_005.tif');
pmrt=double(pmrt); pmrt(pmrt<0)=nan;

fc=imresample([0.05,0.05],fc,[0.1,0.1],'nearest');
sc=imresample([0.05,0.05],sc,[0.1,0.1],'nearest');
fmrt=imresample([0.05,0.05],fmrt,[0.1,0.1],'nearest');
smrt=imresample([0.05,0.05],smrt,[0.1,0.1],'nearest');
pmrt=imresample([0.05,0.05],pmrt,[0.1,0.1],'nearest');


npp2000=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2000_TP_01.tif');
npp2001=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2001_TP_01.tif');
npp2002=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2002_TP_01.tif');
npp2003=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2003_TP_01.tif');
npp2004=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2004_TP_01.tif');
npp2005=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2005_TP_01.tif');
npp2006=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2006_TP_01.tif');
npp2007=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2007_TP_01.tif');
npp2008=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2008_TP_01.tif');
npp2009=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2009_TP_01.tif');
npp2010=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2010_TP_01.tif');
npp2011=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2011_TP_01.tif');
npp2012=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2012_TP_01.tif');
npp2013=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2013_TP_01.tif');
npp2014=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2014_TP_01.tif');
npp2015=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2015_TP_01.tif');

npp=cat(3,npp2000,npp2001,npp2002,npp2003,npp2004,npp2005,npp2006,npp2007,npp2008,npp2009,npp2010,npp2011,npp2012,npp2013,npp2014,npp2015);
npp=double(npp)/10; npp(npp>6500)=nan;
mask_fc=fc; mask_fc(mask_fc>0)=0;

for i=1:16
    npp(:,:,i)=npp(:,:,i)+mask_fc;
end

grids_oc=imread('/Users/shuairen/Desktop/ظԭ__/variables/socd/TP_1m_SOCD_kgCm2_01.tif');%%% λΪ kg/m2;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Clay content/clay_01.mat');
clay_01=mean(clay_01,3,'omitnan')/100;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Bulk density/bd_01.mat');
bd_01=mean(bd_01,3,'omitnan');

load('/Users/shuairen/Desktop/ظԭ__/warming/area_01_km2.mat','area_01_km2');
mask_area1=area_01_km2;
mask_area1=mask_area1+mask_tp; mask_area1=mask_area1(501:650,2501:2850);

grids_oc=(grids_oc.*mask_area1)/(10^6);


for i=1:16
    npp(:,:,i)=(npp(:,:,i).*mask_area1)*10^6/(10^15);
end
npp(:,:,end)=[];


pre(:,:,[1:99 115:end])=[]; tmp(:,:,[1:99 115:end])=[];%%%% 2000-2015
pre=imresample([0.5,0.5],pre,[0.09987,0.09976],'nearest'); tmp=imresample([0.5,0.5],tmp,[0.09987,0.09976],'nearest');

for i=1:15
    pre(:,:,i)=pre(:,:,i)+mask_tp;
    tmp(:,:,i)=tmp(:,:,i)+mask_tp;
end

tmp=tmp(501:650,2501:2850,:);
pre=pre(501:650,2501:2850,:);


ipsl_histnpp_stocks(:,:,1:150)=[]; ipsl_histpr(:,:,1:150)=[]; ipsl_histtas(:,:,1:150)=[];
ipsl_npp1=cat(3,ipsl_histnpp_stocks,ipsl_ssp245npp_stocks);
ipsl_pr1=cat(3,ipsl_histpr,ipsl_ssp245pr);
ipsl_tas1=cat(3,ipsl_histtas,ipsl_ssp245tas);

%%%% delta method
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/mask_area.mat','mask_area');
deg_lo=360/144; deg_la=180/143;
for i=1:101
    st=ipsl_tas1(:,:,i);
    st=imresample([deg_lo deg_la],st,[0.09933,0.09935],'nearest');
    st=st+mask_tp; st=st(501:650,2501:2850);
    ipsl_tas(:,:,i)=st;
    
    pr=ipsl_pr1(:,:,i);
    pr=imresample([deg_lo deg_la],pr,[0.09933,0.09935],'nearest');
    pr=pr+mask_tp; pr=pr(501:650,2501:2850);
    ipsl_pr(:,:,i)=pr;
    
    fvs=ipsl_npp1(:,:,i);
    fvs=fvs./mask_area;
    fvs=imresample([deg_lo deg_la],fvs,[0.09933,0.09935],'nearest');
    fvs=fvs.*area_01_km2;
    fvs=fvs+mask_tp; fvs=fvs(501:650,2501:2850);
    ipsl_npp(:,:,i)=fvs;
end


a=ipsl_tas(:,:,1:15); ipsl_tas(:,:,1:15)=[];
b=ipsl_pr(:,:,1:15); ipsl_pr(:,:,1:15)=[];
c=ipsl_npp(:,:,1:15); ipsl_npp(:,:,1:15)=[];


de_tas1=cat(3,a,a,a,a,a,a); de_tas1(:,:,87:end)=[];
de_tas=cat(3,tmp,tmp,tmp,tmp,tmp,tmp); de_tas(:,:,87:end)=[];
de_pr1=cat(3,b,b,b,b,b,b); de_pr1(:,:,87:end)=[];
de_pr=cat(3,pre,pre,pre,pre,pre,pre); de_pr(:,:,87:end)=[];
de_npp1=cat(3,c,c,c,c,c,c); de_npp1(:,:,87:end)=[];
de_npp=cat(3,npp,npp,npp,npp,npp,npp); de_npp(:,:,87:end)=[];

for i=1:86
    a1=ipsl_tas(:,:,i); b1=ipsl_pr(:,:,i); c1=ipsl_npp(:,:,i);
    ipsl_tas(:,:,i)=mean(de_tas(:,:,1:15),3,'omitnan')+(a1-mean(de_tas1(:,:,1:15),3,'omitnan'));
    ipsl_pr(:,:,i)=mean(de_pr(:,:,1:15),3,'omitnan').*(b1./mean(de_pr1(:,:,1:15),3,'omitnan'));
    ipsl_npp(:,:,i)=mean(de_npp(:,:,1:15),3,'omitnan')+(c1-mean(de_npp1(:,:,1:15),3,'omitnan'));
    
end

load('/Volumes/TU200Pro/4 paper-C turnover/7.Physical protection/3.constrain_hamdi/1 changed_all/max_pre.mat','max_pre');
for i=1:86
    ipsl_pr(:,:,i)=ipsl_pr(:,:,i)/max_pre;
end

clay_01=clay_01+mask_tp; clay_01=clay_01(501:650,2501:2850);
bd_01=bd_01+mask_tp; bd_01=bd_01(501:650,2501:2850);

nu=52500;

fc=reshape(fc,[1,nu]);
sc=reshape(sc,[1,nu]);
fmrt=reshape(fmrt,[1,nu]);
smrt=reshape(smrt,[1,nu]);
pmrt=reshape(pmrt,[1,nu]);
grids_oc=reshape(grids_oc,[1,nu]);
clay_01=reshape(clay_01,[1,nu]);
bd_01=reshape(bd_01,[1,nu]);
mask_area2=reshape(mask_area1,[1,nu])*10^6;
bd_01=bd_01.*mask_area2/10;

for i=1:86
    hst(i,:)=reshape(ipsl_tas(:,:,i),[1,nu]);
    hswc(i,:)=reshape(ipsl_pr(:,:,i),[1,nu]);
    hfs(i,:)=reshape(ipsl_npp(:,:,i),[1,nu]);
end

ctotal=grids_oc;
hcfs=ctotal.*fc; hcms=ctotal.*sc; hcss=ctotal.*(1-fc-sc);
mrt=cat(1,fmrt,smrt,pmrt,clay_01,bd_01);

path='/Users/shuairen/Desktop/ظԭ__/warming/';
load(strcat(path,'consPAR_TP.mat'));
load(strcat(path,'soc_spinup.mat'));

hcfs=mean(hfs_mo,1,'omitnan'); hcms=mean(hms_mo,1,'omitnan'); hcss=mean(hss_mo,1,'omitnan');
ipsl_ssp245pre_hfs(1,:)=hcfs(1,:); ipsl_ssp245pre_hms(1,:)=hcms(1,:); ipsl_ssp245pre_hss(1,:)=hcss(1,:);
for j=1:nu
    cm_last(1,1)=hcfs(1,j); cm_last(2,1)=hcms(1,j); cm_last(3,1)=hcss(1,j);
    for i=1:86
        f_tem=had1(4,j)^((hst(i,j)-15)/10); s_tem=had1(5,j)^((hst(i,j)-15)/10); p_tem=had1(6,j)^((hst(i,j)-15)/10);
        f_moi=(hswc(i,j))^had1(3,j); s_moi=(hswc(i,j))^had1(3,j); p_moi=(hswc(i,j))^had1(3,j);
        if mrt(4,j)==0
            clay=1;
        elseif mrt(4,j)>0 && mrt(4,j)<0.033
            clay=1/(mrt(4,j)*19.6);
        elseif mrt(4,j)>0.033 || mrt(4,j)==0.033
            clay=1/(-2.13*mrt(4,j)^2+6.23*mrt(4,j)+0.55);
        else
            clay=nan;
        end
        
        f_app(i,j)=mrt(1,j)/(f_tem*f_moi*clay);
        if cm_last(1,1)>0
            s_in=cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(cm_last(1,1)+hfs(i,j))*had1(1,j);
            end
        else
            s_in=hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(hfs(i,j))*had1(1,j);
            end
        end
        s_res=s_in*10^14*7.05/(365*mrt(5,j));
        s_pri=1+((2.47*s_res)/(13.01+s_res));
        s_app(i,j)=mrt(2,j)/(s_tem*s_moi*clay)/s_pri;
        
        p_in=cm_last(2,1)*had1(2,j)/s_app(i,j);
        p_res=p_in*10^14*7.05/(365*mrt(5,j));
        p_pri=1+((2.47*p_res)/(13.01+p_res));
        
        p_app(i,j)=mrt(3,j)/(p_tem*p_moi*clay)/p_pri;
        
        if cm_last(1,1)>0
            cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+(cm_last(1,1)+hfs(i,j))*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        else
            cm_present(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        end
        
        %         cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
        %         cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had(1,j)/f_app(i,j);
        %         cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had(2,j)/s_app(i,j);
        
        cm_last=cm_present;
        ipsl_ssp245pre_hfs(i+1,j)=cm_present(1,1); ipsl_ssp245pre_hms(i+1,j)=cm_present(2,1); ipsl_ssp245pre_hss(i+1,j)=cm_present(3,1);
    end
end


mask=ipsl_ssp245pre_hfs(end,:)-ipsl_ssp245pre_hfs(1,:); mask(mask>-10^100)=0;

%%% original C
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histcf_stocks.mat','ipsl_histcf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histcm_stocks.mat','ipsl_histcm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histcs_stocks.mat','ipsl_histcs_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/IPSL-CM6A-LR/ipsl_ssp245cf_stocks.mat','ipsl_ssp245cf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/IPSL-CM6A-LR/ipsl_ssp245cm_stocks.mat','ipsl_ssp245cm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/IPSL-CM6A-LR/ipsl_ssp245cs_stocks.mat','ipsl_ssp245cs_stocks');
    
ipsl_histcf_stocks(:,:,1:150)=[]; ipsl_histcm_stocks(:,:,1:150)=[]; ipsl_histcs_stocks(:,:,1:150)=[];
ipsl_histcf_stocks=mean(ipsl_histcf_stocks,3,'omitnan');
ipsl_histcm_stocks=mean(ipsl_histcm_stocks,3,'omitnan');
ipsl_histcs_stocks=mean(ipsl_histcs_stocks,3,'omitnan');
ipsl_ssp245cf_stocks=cat(3,ipsl_histcf_stocks,ipsl_ssp245cf_stocks);
ipsl_ssp245cm_stocks=cat(3,ipsl_histcm_stocks,ipsl_ssp245cm_stocks);
ipsl_ssp245cs_stocks=cat(3,ipsl_histcs_stocks,ipsl_ssp245cs_stocks);

%%% pre-industrial temperature
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/IPSL-CM6A-LR/ipsl_histtas.mat','ipsl_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/IPSL-CM6A-LR/ipsl_ssp245tas.mat','ipsl_ssp245tas');
ipsl_histtas(:,:,51:end)=[]; ipsl_histtas=mean(ipsl_histtas,3,'omitnan');
ipsl_ssp245tas=cat(3,ipsl_histtas,ipsl_ssp245tas);

for i=1:87
    cf=ipsl_ssp245cf_stocks(:,:,i);
    cf=cf./mask_area;
    cf=imresample([deg_lo deg_la],cf,[0.09933,0.09935],'nearest');
    cf=cf.*area_01_km2;
    cf=cf(501:650,2501:2850);
    ipsl_ssp245cf_orig(:,:,i)=cf;
    
    cm=ipsl_ssp245cm_stocks(:,:,i);
    cm=cm./mask_area;
    cm=imresample([deg_lo deg_la],cm,[0.09933,0.09935],'nearest');
    cm=cm.*area_01_km2;
    cm=cm(501:650,2501:2850);
    ipsl_ssp245cm_orig(:,:,i)=cm;
    
    cs=ipsl_ssp245cs_stocks(:,:,i);
    cs=cs./mask_area;
    cs=imresample([deg_lo deg_la],cs,[0.09933,0.09935],'nearest');
    cs=cs.*area_01_km2;
    cs=cs(501:650,2501:2850);
    ipsl_ssp245cs_orig(:,:,i)=cs;
end


for j=1:87
    f=ipsl_ssp245pre_hfs(j,:);
    f=f+mask;
    f1=ipsl_ssp245cf_orig(:,:,j);
    f1=reshape(f1,1,nu);
    f1=f1+mask;
    hfs1(j,1)=sum(f(:),'omitnan');
    hfs1(j,2)=sum(f1(:),'omitnan');
    m=ipsl_ssp245pre_hms(j,:);
    m=m+mask;
    m1=ipsl_ssp245cm_orig(:,:,j);
    m1=reshape(m1,1,nu);
    m1=m1+mask;
    hfs1(j,3)=sum(m(:),'omitnan');
    hfs1(j,4)=sum(m1(:),'omitnan');
    s=ipsl_ssp245pre_hss(j,:);
    s=s+mask;
    s1=ipsl_ssp245cs_orig(:,:,j);
    s1=reshape(s1,1,nu);
    s1=s1+mask;
    hfs1(j,5)=sum(s(:),'omitnan');
    hfs1(j,6)=sum(s1(:),'omitnan');
    to=f+m+s;
    to1=f1+m1+s1;
    hfs1(j,7)=sum(to(:),'omitnan');
    hfs1(j,8)=sum(to1(:),'omitnan');
    pre2(:,:,j)=reshape(to,150,350);
    ori2(:,:,j)=reshape(to1,150,350);
    pre_f(:,:,j)=reshape(f,150,350);
pre_m(:,:,j)=reshape(m,150,350);
pre_s(:,:,j)=reshape(s,150,350);
    
    t1=ipsl_ssp245tas(:,:,j);
    hfs1(j,9)=mean(t1(:),'omitnan');
end

aa=hfs1(1,:);
for i=1:87
    hfs1(i,:)=hfs1(i,:)-aa;
end


yr=1:87;
plot(yr',hfs1(:,7));
hold on;
plot(yr',hfs1(:,8));

hfs1(:,9)=[];
hfs1= array2table(hfs1,...
    'VariableNames',{'pre_f','ori_f','pre_m','ori_m','pre_s','ori_s','pre_to','ori_to'});

path_out='/Users/shuairen/Desktop/ظԭ__/warming/ssp245/';

ssp245_ipslPRE_f=pre_f;
ssp245_ipslPRE_m=pre_m;
ssp245_ipslPRE_s=pre_s;

save(strcat(path_out,'ssp245_ipsl_pools.mat'), 'ssp245_ipslPRE_f','ssp245_ipslPRE_m','ssp245_ipslPRE_s');

% ssp245_ipslORI=ori2;
% ssp245_ipslPRE=pre2;
% save(strcat(path_out,'ssp245_ipsl.mat'),'ssp245_ipslORI','ssp245_ipslPRE'); %%% modis and soilgrids
% writetable(hfs1,strcat(path_out,'ssp245_ipsl_yearly.csv'),'WriteRowNames',false);



%% NorESM2-LM; prediction-ssp585; constrain; use for ѭ
clc;clear;
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histnpp_stocks.mat','norlm_histnpp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histtas.mat','norlm_histtas')
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histpr.mat','norlm_histpr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/NorESM2-LM/norlm_ssp585npp_stocks.mat','norlm_ssp585npp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/NorESM2-LM/norlm_ssp585tas.mat','norlm_ssp585tas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/NorESM2-LM/norlm_ssp585pr.mat','norlm_ssp585pr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/2. ˮ/pre.mat');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/1. ¶/tmp.mat');
load('/Users/shuairen/Desktop/ظԭ__/warming/mask_tp.mat','mask_tp');

fc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fcp_tp_005.tif');
fc=double(fc); fc(fc<0)=nan;
sc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/scp_tp_005.tif');
sc=double(sc); sc(sc<0)=nan;
fmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fmrt_tp_005.tif');
fmrt=double(fmrt); fmrt(fmrt<0)=nan;
smrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/smrt_tp_005.tif');
smrt=double(smrt); smrt(smrt<0)=nan;
pmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/pmrt_tp_005.tif');
pmrt=double(pmrt); pmrt(pmrt<0)=nan;

fc=imresample([0.05,0.05],fc,[0.1,0.1],'nearest');
sc=imresample([0.05,0.05],sc,[0.1,0.1],'nearest');
fmrt=imresample([0.05,0.05],fmrt,[0.1,0.1],'nearest');
smrt=imresample([0.05,0.05],smrt,[0.1,0.1],'nearest');
pmrt=imresample([0.05,0.05],pmrt,[0.1,0.1],'nearest');


npp2000=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2000_TP_01.tif');
npp2001=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2001_TP_01.tif');
npp2002=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2002_TP_01.tif');
npp2003=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2003_TP_01.tif');
npp2004=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2004_TP_01.tif');
npp2005=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2005_TP_01.tif');
npp2006=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2006_TP_01.tif');
npp2007=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2007_TP_01.tif');
npp2008=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2008_TP_01.tif');
npp2009=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2009_TP_01.tif');
npp2010=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2010_TP_01.tif');
npp2011=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2011_TP_01.tif');
npp2012=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2012_TP_01.tif');
npp2013=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2013_TP_01.tif');
npp2014=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2014_TP_01.tif');
npp2015=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2015_TP_01.tif');

npp=cat(3,npp2000,npp2001,npp2002,npp2003,npp2004,npp2005,npp2006,npp2007,npp2008,npp2009,npp2010,npp2011,npp2012,npp2013,npp2014,npp2015);
npp=double(npp)/10; npp(npp>6500)=nan;
mask_fc=fc; mask_fc(mask_fc>0)=0;

for i=1:16
    npp(:,:,i)=npp(:,:,i)+mask_fc;
end

grids_oc=imread('/Users/shuairen/Desktop/ظԭ__/variables/socd/TP_1m_SOCD_kgCm2_01.tif');%%% λΪ kg/m2;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Clay content/clay_01.mat');
clay_01=mean(clay_01,3,'omitnan')/100;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Bulk density/bd_01.mat');
bd_01=mean(bd_01,3,'omitnan');

load('/Users/shuairen/Desktop/ظԭ__/warming/area_01_km2.mat','area_01_km2');
mask_area1=area_01_km2;
mask_area1=mask_area1+mask_tp; mask_area1=mask_area1(501:650,2501:2850);

grids_oc=(grids_oc.*mask_area1)/(10^6);


for i=1:16
    npp(:,:,i)=(npp(:,:,i).*mask_area1)*10^6/(10^15);
end
npp(:,:,end)=[];


pre(:,:,[1:99 115:end])=[]; tmp(:,:,[1:99 115:end])=[];%%%% 2000-2015
pre=imresample([0.5,0.5],pre,[0.09987,0.09976],'nearest'); tmp=imresample([0.5,0.5],tmp,[0.09987,0.09976],'nearest');

for i=1:15
    pre(:,:,i)=pre(:,:,i)+mask_tp;
    tmp(:,:,i)=tmp(:,:,i)+mask_tp;
end

tmp=tmp(501:650,2501:2850,:);
pre=pre(501:650,2501:2850,:);


norlm_histnpp_stocks(:,:,1:150)=[]; norlm_histpr(:,:,1:50)=[]; norlm_histtas(:,:,1:150)=[];
norlm_npp1=cat(3,norlm_histnpp_stocks,norlm_ssp585npp_stocks);
norlm_pr1=cat(3,norlm_histpr,norlm_ssp585pr);
norlm_tas1=cat(3,norlm_histtas,norlm_ssp585tas);

%%%% delta method
load('/Volumes/TU200Pro/4 paper-C turnover/2./noresm1_mask_area.mat','mask_area');
deg_lo=360/144; deg_la=180/96;
for i=1:101
    st=norlm_tas1(:,:,i);
    st=imresample([deg_lo deg_la],st,[0.09933,0.099],'nearest');
    st=st+mask_tp; st=st(501:650,2501:2850);
    norlm_tas(:,:,i)=st;
    
    pr=norlm_pr1(:,:,i);
    pr=imresample([deg_lo deg_la],pr,[0.09933,0.099],'nearest');
    pr=pr+mask_tp; pr=pr(501:650,2501:2850);
    norlm_pr(:,:,i)=pr;
    
    fvs=norlm_npp1(:,:,i);
    fvs=fvs./mask_area;
    fvs=imresample([deg_lo deg_la],fvs,[0.09933,0.099],'nearest');
    fvs=fvs.*area_01_km2;
    fvs=fvs+mask_tp; fvs=fvs(501:650,2501:2850);
    norlm_npp(:,:,i)=fvs;
end


a=norlm_tas(:,:,1:15); norlm_tas(:,:,1:15)=[];
b=norlm_pr(:,:,1:15); norlm_pr(:,:,1:15)=[];
c=norlm_npp(:,:,1:15); norlm_npp(:,:,1:15)=[];


de_tas1=cat(3,a,a,a,a,a,a); de_tas1(:,:,87:end)=[];
de_tas=cat(3,tmp,tmp,tmp,tmp,tmp,tmp); de_tas(:,:,87:end)=[];
de_pr1=cat(3,b,b,b,b,b,b); de_pr1(:,:,87:end)=[];
de_pr=cat(3,pre,pre,pre,pre,pre,pre); de_pr(:,:,87:end)=[];
de_npp1=cat(3,c,c,c,c,c,c); de_npp1(:,:,87:end)=[];
de_npp=cat(3,npp,npp,npp,npp,npp,npp); de_npp(:,:,87:end)=[];


for i=1:86
    a1=norlm_tas(:,:,i); b1=norlm_pr(:,:,i); c1=norlm_npp(:,:,i);
    norlm_tas(:,:,i)=mean(de_tas(:,:,1:15),3,'omitnan')+(a1-mean(de_tas1(:,:,1:15),3,'omitnan'));
    norlm_pr(:,:,i)=mean(de_pr(:,:,1:15),3,'omitnan').*(b1./mean(de_pr1(:,:,1:15),3,'omitnan'));
    norlm_npp(:,:,i)=mean(de_npp(:,:,1:15),3,'omitnan')+(c1-mean(de_npp1(:,:,1:15),3,'omitnan'));
    
end


load('/Volumes/TU200Pro/4 paper-C turnover/7.Physical protection/3.constrain_hamdi/1 changed_all/max_pre.mat','max_pre');
for i=1:86
    
    norlm_pr(:,:,i)=norlm_pr(:,:,i)/max_pre;
end

clay_01=clay_01+mask_tp; clay_01=clay_01(501:650,2501:2850);
bd_01=bd_01+mask_tp; bd_01=bd_01(501:650,2501:2850);

nu=52500;

fc=reshape(fc,[1,nu]);
sc=reshape(sc,[1,nu]);
fmrt=reshape(fmrt,[1,nu]);
smrt=reshape(smrt,[1,nu]);
pmrt=reshape(pmrt,[1,nu]);
grids_oc=reshape(grids_oc,[1,nu]);
clay_01=reshape(clay_01,[1,nu]);
bd_01=reshape(bd_01,[1,nu]);
mask_area2=reshape(mask_area1,[1,nu])*10^6;
bd_01=bd_01.*mask_area2/10;

for i=1:86
    hst(i,:)=reshape(norlm_tas(:,:,i),[1,nu]);
    hswc(i,:)=reshape(norlm_pr(:,:,i),[1,nu]);
    hfs(i,:)=reshape(norlm_npp(:,:,i),[1,nu]);
end

ctotal=grids_oc;
hcfs=ctotal.*fc; hcms=ctotal.*sc; hcss=ctotal.*(1-fc-sc);
mrt=cat(1,fmrt,smrt,pmrt,clay_01,bd_01);


path='/Users/shuairen/Desktop/ظԭ__/warming/';
load(strcat(path,'consPAR_TP.mat'));
load(strcat(path,'soc_spinup.mat'));


hcfs=mean(hfs_mo,1,'omitnan'); hcms=mean(hms_mo,1,'omitnan'); hcss=mean(hss_mo,1,'omitnan');
norlm_ssp585pre_hfs(1,:)=hcfs(1,:);norlm_ssp585pre_hms(1,:)=hcms(1,:); norlm_ssp585pre_hss(1,:)=hcss(1,:);
for j=1:nu
    cm_last(1,1)=hcfs(1,j); cm_last(2,1)=hcms(1,j); cm_last(3,1)=hcss(1,j);
    for i=1:86
        f_tem=had1(4,j)^((hst(i,j)-15)/10); s_tem=had1(5,j)^((hst(i,j)-15)/10); p_tem=had1(6,j)^((hst(i,j)-15)/10);
        f_moi=(hswc(i,j))^had1(3,j); s_moi=(hswc(i,j))^had1(3,j); p_moi=(hswc(i,j))^had1(3,j);
        if mrt(4,j)==0
            clay=1;
        elseif mrt(4,j)>0 && mrt(4,j)<0.033
            clay=1/(mrt(4,j)*19.6);
        elseif mrt(4,j)>0.033 || mrt(4,j)==0.033
            clay=1/(-2.13*mrt(4,j)^2+6.23*mrt(4,j)+0.55);
        else
            clay=nan;
        end
        
        f_app(i,j)=mrt(1,j)/(f_tem*f_moi*clay);
        if cm_last(1,1)>0
            s_in=cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(cm_last(1,1)+hfs(i,j))*had1(1,j);
            end
        else
            s_in=hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(hfs(i,j))*had1(1,j);
            end
        end
        s_res=s_in*10^14*7.05/(365*mrt(5,j));
        s_pri=1+((2.47*s_res)/(13.01+s_res));
        s_app(i,j)=mrt(2,j)/(s_tem*s_moi*clay)/s_pri;
        
        p_in=cm_last(2,1)*had1(2,j)/s_app(i,j);
        p_res=p_in*10^14*7.05/(365*mrt(5,j));
        p_pri=1+((2.47*p_res)/(13.01+p_res));
        
        p_app(i,j)=mrt(3,j)/(p_tem*p_moi*clay)/p_pri;
        
        if cm_last(1,1)>0
            cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+(cm_last(1,1)+hfs(i,j))*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        else
            cm_present(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        end
        
        %         cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
        %         cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had(1,j)/f_app(i,j);
        %         cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had(2,j)/s_app(i,j);
        
        cm_last=cm_present;
        norlm_ssp585pre_hfs(i+1,j)=cm_present(1,1); norlm_ssp585pre_hms(i+1,j)=cm_present(2,1); norlm_ssp585pre_hss(i+1,j)=cm_present(3,1);
    end
end


mask=norlm_ssp585pre_hfs(end,:)-norlm_ssp585pre_hfs(1,:); mask(mask>-10^100)=0;


%%% original C
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histcf_stocks.mat','norlm_histcf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histcm_stocks.mat','norlm_histcm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histcs_stocks.mat','norlm_histcs_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/NorESM2-LM/norlm_ssp585cf_stocks.mat','norlm_ssp585cf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/NorESM2-LM/norlm_ssp585cm_stocks.mat','norlm_ssp585cm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/NorESM2-LM/norlm_ssp585cs_stocks.mat','norlm_ssp585cs_stocks');
    
norlm_histcf_stocks(:,:,1:150)=[]; norlm_histcm_stocks(:,:,1:150)=[]; norlm_histcs_stocks(:,:,1:150)=[];
norlm_histcf_stocks=mean(norlm_histcf_stocks,3,'omitnan');
norlm_histcm_stocks=mean(norlm_histcm_stocks,3,'omitnan');
norlm_histcs_stocks=mean(norlm_histcs_stocks,3,'omitnan');
norlm_ssp585cf_stocks=cat(3,norlm_histcf_stocks,norlm_ssp585cf_stocks);
norlm_ssp585cm_stocks=cat(3,norlm_histcm_stocks,norlm_ssp585cm_stocks);
norlm_ssp585cs_stocks=cat(3,norlm_histcs_stocks,norlm_ssp585cs_stocks);

%%% pre-industrial temperature
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histtas.mat','norlm_histtas')
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/NorESM2-LM/norlm_ssp585tas.mat','norlm_ssp585tas');
norlm_histtas(:,:,51:end)=[]; norlm_histtas=mean(norlm_histtas,3,'omitnan');
norlm_ssp585tas=cat(3,norlm_histtas,norlm_ssp585tas);

for i=1:87
    cf=norlm_ssp585cf_stocks(:,:,i);
    cf=cf./mask_area;
    cf=imresample([deg_lo deg_la],cf,[0.09933,0.099],'nearest');
    cf=cf.*area_01_km2;
    cf=cf(501:650,2501:2850);
    norlm_ssp585cf_orig(:,:,i)=cf;
    
    cm=norlm_ssp585cm_stocks(:,:,i);
    cm=cm./mask_area;
    cm=imresample([deg_lo deg_la],cm,[0.09933,0.099],'nearest');
    cm=cm.*area_01_km2;
    cm=cm(501:650,2501:2850);
    norlm_ssp585cm_orig(:,:,i)=cm;
    
    cs=norlm_ssp585cs_stocks(:,:,i);
    cs=cs./mask_area;
    cs=imresample([deg_lo deg_la],cs,[0.09933,0.099],'nearest');
    cs=cs.*area_01_km2;
    cs=cs(501:650,2501:2850);
    norlm_ssp585cs_orig(:,:,i)=cs;
end


for j=1:87
    f=norlm_ssp585pre_hfs(j,:);
    f=f+mask;
    f1=norlm_ssp585cf_orig(:,:,j);
    f1=reshape(f1,1,nu);
    f1=f1+mask;
    hfs1(j,1)=sum(f(:),'omitnan');
    hfs1(j,2)=sum(f1(:),'omitnan');
    m=norlm_ssp585pre_hms(j,:);
    m=m+mask;
    m1=norlm_ssp585cm_orig(:,:,j);
    m1=reshape(m1,1,nu);
    m1=m1+mask;
    hfs1(j,3)=sum(m(:),'omitnan');
    hfs1(j,4)=sum(m1(:),'omitnan');
    s=norlm_ssp585pre_hss(j,:);
    s=s+mask;
    s1=norlm_ssp585cs_orig(:,:,j);
    s1=reshape(s1,1,nu);
    s1=s1+mask;
    hfs1(j,5)=sum(s(:),'omitnan');
    hfs1(j,6)=sum(s1(:),'omitnan');
    to=f+m+s;
    to1=f1+m1+s1;
    hfs1(j,7)=sum(to(:),'omitnan');
    hfs1(j,8)=sum(to1(:),'omitnan');
    pre2(:,:,j)=reshape(to,150,350);
    ori2(:,:,j)=reshape(to1,150,350);
    pre_f(:,:,j)=reshape(f,150,350);
pre_m(:,:,j)=reshape(m,150,350);
pre_s(:,:,j)=reshape(s,150,350);
    
    t1=norlm_ssp585tas(:,:,j);
    hfs1(j,9)=mean(t1(:),'omitnan');
end

aa=hfs1(1,:);
for i=1:87
    hfs1(i,:)=hfs1(i,:)-aa;
end


yr=1:87;
plot(yr',hfs1(:,7));
hold on;
plot(yr',hfs1(:,8));

hfs1(:,9)=[];
hfs1= array2table(hfs1,...
    'VariableNames',{'pre_f','ori_f','pre_m','ori_m','pre_s','ori_s','pre_to','ori_to'});

path_out='/Users/shuairen/Desktop/ظԭ__/warming/ssp585/';

ssp585_norlmPRE_f=pre_f;
ssp585_norlmPRE_m=pre_m;
ssp585_norlmPRE_s=pre_s;

save(strcat(path_out,'ssp585_norlm_pools.mat'), 'ssp585_norlmPRE_f','ssp585_norlmPRE_m','ssp585_norlmPRE_s');


% ssp585_norlmORI=ori2;
% ssp585_norlmPRE=pre2;
% save(strcat(path_out,'ssp585_norlm.mat'),'ssp585_norlmORI','ssp585_norlmPRE'); %%% modis and soilgrids
% writetable(hfs1,strcat(path_out,'ssp585_norlm_yearly.csv'),'WriteRowNames',false);



%% NorESM2-LM; prediction-ssp245; constrain; use for ѭ
clc;clear;
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histnpp_stocks.mat','norlm_histnpp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histtas.mat','norlm_histtas')
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histpr.mat','norlm_histpr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/NorESM2-LM/norlm_ssp245npp_stocks.mat','norlm_ssp245npp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/NorESM2-LM/norlm_ssp245tas.mat','norlm_ssp245tas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/NorESM2-LM/norlm_ssp245pr.mat','norlm_ssp245pr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/2. ˮ/pre.mat');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/1. ¶/tmp.mat');
load('/Users/shuairen/Desktop/ظԭ__/warming/mask_tp.mat','mask_tp');

fc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fcp_tp_005.tif');
fc=double(fc); fc(fc<0)=nan;
sc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/scp_tp_005.tif');
sc=double(sc); sc(sc<0)=nan;
fmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fmrt_tp_005.tif');
fmrt=double(fmrt); fmrt(fmrt<0)=nan;
smrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/smrt_tp_005.tif');
smrt=double(smrt); smrt(smrt<0)=nan;
pmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/pmrt_tp_005.tif');
pmrt=double(pmrt); pmrt(pmrt<0)=nan;

fc=imresample([0.05,0.05],fc,[0.1,0.1],'nearest');
sc=imresample([0.05,0.05],sc,[0.1,0.1],'nearest');
fmrt=imresample([0.05,0.05],fmrt,[0.1,0.1],'nearest');
smrt=imresample([0.05,0.05],smrt,[0.1,0.1],'nearest');
pmrt=imresample([0.05,0.05],pmrt,[0.1,0.1],'nearest');


npp2000=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2000_TP_01.tif');
npp2001=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2001_TP_01.tif');
npp2002=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2002_TP_01.tif');
npp2003=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2003_TP_01.tif');
npp2004=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2004_TP_01.tif');
npp2005=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2005_TP_01.tif');
npp2006=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2006_TP_01.tif');
npp2007=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2007_TP_01.tif');
npp2008=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2008_TP_01.tif');
npp2009=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2009_TP_01.tif');
npp2010=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2010_TP_01.tif');
npp2011=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2011_TP_01.tif');
npp2012=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2012_TP_01.tif');
npp2013=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2013_TP_01.tif');
npp2014=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2014_TP_01.tif');
npp2015=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2015_TP_01.tif');

npp=cat(3,npp2000,npp2001,npp2002,npp2003,npp2004,npp2005,npp2006,npp2007,npp2008,npp2009,npp2010,npp2011,npp2012,npp2013,npp2014,npp2015);
npp=double(npp)/10; npp(npp>6500)=nan;
mask_fc=fc; mask_fc(mask_fc>0)=0;

for i=1:16
    npp(:,:,i)=npp(:,:,i)+mask_fc;
end

grids_oc=imread('/Users/shuairen/Desktop/ظԭ__/variables/socd/TP_1m_SOCD_kgCm2_01.tif');%%% λΪ kg/m2;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Clay content/clay_01.mat');
clay_01=mean(clay_01,3,'omitnan')/100;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Bulk density/bd_01.mat');
bd_01=mean(bd_01,3,'omitnan');

load('/Users/shuairen/Desktop/ظԭ__/warming/area_01_km2.mat','area_01_km2');
mask_area1=area_01_km2;
mask_area1=mask_area1+mask_tp; mask_area1=mask_area1(501:650,2501:2850);

grids_oc=(grids_oc.*mask_area1)/(10^6);


for i=1:16
    npp(:,:,i)=(npp(:,:,i).*mask_area1)*10^6/(10^15);
end
npp(:,:,end)=[];


pre(:,:,[1:99 115:end])=[]; tmp(:,:,[1:99 115:end])=[];%%%% 2000-2015
pre=imresample([0.5,0.5],pre,[0.09987,0.09976],'nearest'); tmp=imresample([0.5,0.5],tmp,[0.09987,0.09976],'nearest');

for i=1:15
    pre(:,:,i)=pre(:,:,i)+mask_tp;
    tmp(:,:,i)=tmp(:,:,i)+mask_tp;
end

tmp=tmp(501:650,2501:2850,:);
pre=pre(501:650,2501:2850,:);


norlm_histnpp_stocks(:,:,1:150)=[]; norlm_histpr(:,:,1:50)=[]; norlm_histtas(:,:,1:150)=[];
norlm_npp1=cat(3,norlm_histnpp_stocks,norlm_ssp245npp_stocks);
norlm_pr1=cat(3,norlm_histpr,norlm_ssp245pr);
norlm_tas1=cat(3,norlm_histtas,norlm_ssp245tas);

%%%% delta method
load('/Volumes/TU200Pro/4 paper-C turnover/2./noresm1_mask_area.mat','mask_area');
deg_lo=360/144; deg_la=180/96;
for i=1:101
    st=norlm_tas1(:,:,i);
    st=imresample([deg_lo deg_la],st,[0.09933,0.099],'nearest');
    st=st+mask_tp; st=st(501:650,2501:2850);
    norlm_tas(:,:,i)=st;
    
    pr=norlm_pr1(:,:,i);
    pr=imresample([deg_lo deg_la],pr,[0.09933,0.099],'nearest');
    pr=pr+mask_tp; pr=pr(501:650,2501:2850);
    norlm_pr(:,:,i)=pr;
    
    fvs=norlm_npp1(:,:,i);
    fvs=fvs./mask_area;
    fvs=imresample([deg_lo deg_la],fvs,[0.09933,0.099],'nearest');
    fvs=fvs.*area_01_km2;
    fvs=fvs+mask_tp; fvs=fvs(501:650,2501:2850);
    norlm_npp(:,:,i)=fvs;
end


a=norlm_tas(:,:,1:15); norlm_tas(:,:,1:15)=[];
b=norlm_pr(:,:,1:15); norlm_pr(:,:,1:15)=[];
c=norlm_npp(:,:,1:15); norlm_npp(:,:,1:15)=[];


de_tas1=cat(3,a,a,a,a,a,a); de_tas1(:,:,87:end)=[];
de_tas=cat(3,tmp,tmp,tmp,tmp,tmp,tmp); de_tas(:,:,87:end)=[];
de_pr1=cat(3,b,b,b,b,b,b); de_pr1(:,:,87:end)=[];
de_pr=cat(3,pre,pre,pre,pre,pre,pre); de_pr(:,:,87:end)=[];
de_npp1=cat(3,c,c,c,c,c,c); de_npp1(:,:,87:end)=[];
de_npp=cat(3,npp,npp,npp,npp,npp,npp); de_npp(:,:,87:end)=[];


for i=1:86
    a1=norlm_tas(:,:,i); b1=norlm_pr(:,:,i); c1=norlm_npp(:,:,i);
    norlm_tas(:,:,i)=mean(de_tas(:,:,1:15),3,'omitnan')+(a1-mean(de_tas1(:,:,1:15),3,'omitnan'));
    norlm_pr(:,:,i)=mean(de_pr(:,:,1:15),3,'omitnan').*(b1./mean(de_pr1(:,:,1:15),3,'omitnan'));
    norlm_npp(:,:,i)=mean(de_npp(:,:,1:15),3,'omitnan')+(c1-mean(de_npp1(:,:,1:15),3,'omitnan'));
    
end


load('/Volumes/TU200Pro/4 paper-C turnover/7.Physical protection/3.constrain_hamdi/1 changed_all/max_pre.mat','max_pre');
for i=1:86
    
    norlm_pr(:,:,i)=norlm_pr(:,:,i)/max_pre;
end

clay_01=clay_01+mask_tp; clay_01=clay_01(501:650,2501:2850);
bd_01=bd_01+mask_tp; bd_01=bd_01(501:650,2501:2850);

nu=52500;

fc=reshape(fc,[1,nu]);
sc=reshape(sc,[1,nu]);
fmrt=reshape(fmrt,[1,nu]);
smrt=reshape(smrt,[1,nu]);
pmrt=reshape(pmrt,[1,nu]);
grids_oc=reshape(grids_oc,[1,nu]);
clay_01=reshape(clay_01,[1,nu]);
bd_01=reshape(bd_01,[1,nu]);
mask_area2=reshape(mask_area1,[1,nu])*10^6;
bd_01=bd_01.*mask_area2/10;

for i=1:86
    hst(i,:)=reshape(norlm_tas(:,:,i),[1,nu]);
    hswc(i,:)=reshape(norlm_pr(:,:,i),[1,nu]);
    hfs(i,:)=reshape(norlm_npp(:,:,i),[1,nu]);
end

ctotal=grids_oc;
hcfs=ctotal.*fc; hcms=ctotal.*sc; hcss=ctotal.*(1-fc-sc);
mrt=cat(1,fmrt,smrt,pmrt,clay_01,bd_01);


path='/Users/shuairen/Desktop/ظԭ__/warming/';
load(strcat(path,'consPAR_TP.mat'));
load(strcat(path,'soc_spinup.mat'));


hcfs=mean(hfs_mo,1,'omitnan'); hcms=mean(hms_mo,1,'omitnan'); hcss=mean(hss_mo,1,'omitnan');
norlm_ssp245pre_hfs(1,:)=hcfs(1,:);norlm_ssp245pre_hms(1,:)=hcms(1,:); norlm_ssp245pre_hss(1,:)=hcss(1,:);
for j=1:nu
    cm_last(1,1)=hcfs(1,j); cm_last(2,1)=hcms(1,j); cm_last(3,1)=hcss(1,j);
    for i=1:86
        f_tem=had1(4,j)^((hst(i,j)-15)/10); s_tem=had1(5,j)^((hst(i,j)-15)/10); p_tem=had1(6,j)^((hst(i,j)-15)/10);
        f_moi=(hswc(i,j))^had1(3,j); s_moi=(hswc(i,j))^had1(3,j); p_moi=(hswc(i,j))^had1(3,j);
        if mrt(4,j)==0
            clay=1;
        elseif mrt(4,j)>0 && mrt(4,j)<0.033
            clay=1/(mrt(4,j)*19.6);
        elseif mrt(4,j)>0.033 || mrt(4,j)==0.033
            clay=1/(-2.13*mrt(4,j)^2+6.23*mrt(4,j)+0.55);
        else
            clay=nan;
        end
        
        f_app(i,j)=mrt(1,j)/(f_tem*f_moi*clay);
        if cm_last(1,1)>0
            s_in=cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(cm_last(1,1)+hfs(i,j))*had1(1,j);
            end
        else
            s_in=hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(hfs(i,j))*had1(1,j);
            end
        end
        s_res=s_in*10^14*7.05/(365*mrt(5,j));
        s_pri=1+((2.47*s_res)/(13.01+s_res));
        s_app(i,j)=mrt(2,j)/(s_tem*s_moi*clay)/s_pri;
        
        p_in=cm_last(2,1)*had1(2,j)/s_app(i,j);
        p_res=p_in*10^14*7.05/(365*mrt(5,j));
        p_pri=1+((2.47*p_res)/(13.01+p_res));
        
        p_app(i,j)=mrt(3,j)/(p_tem*p_moi*clay)/p_pri;
        
        if cm_last(1,1)>0
            cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+(cm_last(1,1)+hfs(i,j))*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        else
            cm_present(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        end
        
        %         cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
        %         cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had(1,j)/f_app(i,j);
        %         cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had(2,j)/s_app(i,j);
        
        cm_last=cm_present;
        norlm_ssp245pre_hfs(i+1,j)=cm_present(1,1); norlm_ssp245pre_hms(i+1,j)=cm_present(2,1); norlm_ssp245pre_hss(i+1,j)=cm_present(3,1);
    end
end


mask=norlm_ssp245pre_hfs(end,:)-norlm_ssp245pre_hfs(1,:); mask(mask>-10^100)=0;


%%% original C
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histcf_stocks.mat','norlm_histcf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histcm_stocks.mat','norlm_histcm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histcs_stocks.mat','norlm_histcs_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/NorESM2-LM/norlm_ssp245cf_stocks.mat','norlm_ssp245cf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/NorESM2-LM/norlm_ssp245cm_stocks.mat','norlm_ssp245cm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/NorESM2-LM/norlm_ssp245cs_stocks.mat','norlm_ssp245cs_stocks');
    
norlm_histcf_stocks(:,:,1:150)=[]; norlm_histcm_stocks(:,:,1:150)=[]; norlm_histcs_stocks(:,:,1:150)=[];
norlm_histcf_stocks=mean(norlm_histcf_stocks,3,'omitnan');
norlm_histcm_stocks=mean(norlm_histcm_stocks,3,'omitnan');
norlm_histcs_stocks=mean(norlm_histcs_stocks,3,'omitnan');
norlm_ssp245cf_stocks=cat(3,norlm_histcf_stocks,norlm_ssp245cf_stocks);
norlm_ssp245cm_stocks=cat(3,norlm_histcm_stocks,norlm_ssp245cm_stocks);
norlm_ssp245cs_stocks=cat(3,norlm_histcs_stocks,norlm_ssp245cs_stocks);

%%% pre-industrial temperature
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/NorESM2-LM/norlm_histtas.mat','norlm_histtas')
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/NorESM2-LM/norlm_ssp245tas.mat','norlm_ssp245tas');
norlm_histtas(:,:,51:end)=[]; norlm_histtas=mean(norlm_histtas,3,'omitnan');
norlm_ssp245tas=cat(3,norlm_histtas,norlm_ssp245tas);

for i=1:87
    cf=norlm_ssp245cf_stocks(:,:,i);
    cf=cf./mask_area;
    cf=imresample([deg_lo deg_la],cf,[0.09933,0.099],'nearest');
    cf=cf.*area_01_km2;
    cf=cf(501:650,2501:2850);
    norlm_ssp245cf_orig(:,:,i)=cf;
    
    cm=norlm_ssp245cm_stocks(:,:,i);
    cm=cm./mask_area;
    cm=imresample([deg_lo deg_la],cm,[0.09933,0.099],'nearest');
    cm=cm.*area_01_km2;
    cm=cm(501:650,2501:2850);
    norlm_ssp245cm_orig(:,:,i)=cm;
    
    cs=norlm_ssp245cs_stocks(:,:,i);
    cs=cs./mask_area;
    cs=imresample([deg_lo deg_la],cs,[0.09933,0.099],'nearest');
    cs=cs.*area_01_km2;
    cs=cs(501:650,2501:2850);
    norlm_ssp245cs_orig(:,:,i)=cs;
end


for j=1:87
    f=norlm_ssp245pre_hfs(j,:);
    f=f+mask;
    f1=norlm_ssp245cf_orig(:,:,j);
    f1=reshape(f1,1,nu);
    f1=f1+mask;
    hfs1(j,1)=sum(f(:),'omitnan');
    hfs1(j,2)=sum(f1(:),'omitnan');
    m=norlm_ssp245pre_hms(j,:);
    m=m+mask;
    m1=norlm_ssp245cm_orig(:,:,j);
    m1=reshape(m1,1,nu);
    m1=m1+mask;
    hfs1(j,3)=sum(m(:),'omitnan');
    hfs1(j,4)=sum(m1(:),'omitnan');
    s=norlm_ssp245pre_hss(j,:);
    s=s+mask;
    s1=norlm_ssp245cs_orig(:,:,j);
    s1=reshape(s1,1,nu);
    s1=s1+mask;
    hfs1(j,5)=sum(s(:),'omitnan');
    hfs1(j,6)=sum(s1(:),'omitnan');
    to=f+m+s;
    to1=f1+m1+s1;
    hfs1(j,7)=sum(to(:),'omitnan');
    hfs1(j,8)=sum(to1(:),'omitnan');
    pre2(:,:,j)=reshape(to,150,350);
    ori2(:,:,j)=reshape(to1,150,350);
    pre_f(:,:,j)=reshape(f,150,350);
pre_m(:,:,j)=reshape(m,150,350);
pre_s(:,:,j)=reshape(s,150,350);
    
    t1=norlm_ssp245tas(:,:,j);
    hfs1(j,9)=mean(t1(:),'omitnan');
end

aa=hfs1(1,:);
for i=1:87
    hfs1(i,:)=hfs1(i,:)-aa;
end


yr=1:87;
plot(yr',hfs1(:,7));
hold on;
plot(yr',hfs1(:,8));

hfs1(:,9)=[];
hfs1= array2table(hfs1,...
    'VariableNames',{'pre_f','ori_f','pre_m','ori_m','pre_s','ori_s','pre_to','ori_to'});

path_out='/Users/shuairen/Desktop/ظԭ__/warming/ssp245/';

ssp245_norlmPRE_f=pre_f;
ssp245_norlmPRE_m=pre_m;
ssp245_norlmPRE_s=pre_s;

save(strcat(path_out,'ssp245_norlm_pools.mat'), 'ssp245_norlmPRE_f','ssp245_norlmPRE_m','ssp245_norlmPRE_s');


% ssp245_norlmORI=ori2;
% ssp245_norlmPRE=pre2;
% save(strcat(path_out,'ssp245_norlm.mat'),'ssp245_norlmORI','ssp245_norlmPRE'); %%% modis and soilgrids
% writetable(hfs1,strcat(path_out,'ssp245_norlm_yearly.csv'),'WriteRowNames',false);



%% TaiESM1; prediction-ssp585; constrain; use for ѭ
clc;clear;
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histnpp_stocks.mat','tai_histnpp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histtas.mat','tai_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histpr.mat','tai_histpr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/TaiESM1/tai_ssp585npp_stocks.mat','tai_ssp585npp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/TaiESM1/tai_ssp585tas.mat','tai_ssp585tas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/TaiESM1/tai_ssp585pr.mat','tai_ssp585pr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/2. ˮ/pre.mat');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/1. ¶/tmp.mat');

load('/Users/shuairen/Desktop/ظԭ__/warming/mask_tp.mat','mask_tp');

fc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fcp_tp_005.tif');
fc=double(fc); fc(fc<0)=nan;
sc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/scp_tp_005.tif');
sc=double(sc); sc(sc<0)=nan;
fmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fmrt_tp_005.tif');
fmrt=double(fmrt); fmrt(fmrt<0)=nan;
smrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/smrt_tp_005.tif');
smrt=double(smrt); smrt(smrt<0)=nan;
pmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/pmrt_tp_005.tif');
pmrt=double(pmrt); pmrt(pmrt<0)=nan;

fc=imresample([0.05,0.05],fc,[0.1,0.1],'nearest');
sc=imresample([0.05,0.05],sc,[0.1,0.1],'nearest');
fmrt=imresample([0.05,0.05],fmrt,[0.1,0.1],'nearest');
smrt=imresample([0.05,0.05],smrt,[0.1,0.1],'nearest');
pmrt=imresample([0.05,0.05],pmrt,[0.1,0.1],'nearest');


npp2000=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2000_TP_01.tif');
npp2001=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2001_TP_01.tif');
npp2002=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2002_TP_01.tif');
npp2003=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2003_TP_01.tif');
npp2004=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2004_TP_01.tif');
npp2005=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2005_TP_01.tif');
npp2006=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2006_TP_01.tif');
npp2007=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2007_TP_01.tif');
npp2008=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2008_TP_01.tif');
npp2009=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2009_TP_01.tif');
npp2010=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2010_TP_01.tif');
npp2011=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2011_TP_01.tif');
npp2012=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2012_TP_01.tif');
npp2013=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2013_TP_01.tif');
npp2014=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2014_TP_01.tif');
npp2015=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2015_TP_01.tif');

npp=cat(3,npp2000,npp2001,npp2002,npp2003,npp2004,npp2005,npp2006,npp2007,npp2008,npp2009,npp2010,npp2011,npp2012,npp2013,npp2014,npp2015);
npp=double(npp)/10; npp(npp>6500)=nan;
mask_fc=fc; mask_fc(mask_fc>0)=0;

for i=1:16
    npp(:,:,i)=npp(:,:,i)+mask_fc;
end

grids_oc=imread('/Users/shuairen/Desktop/ظԭ__/variables/socd/TP_1m_SOCD_kgCm2_01.tif');%%% λΪ kg/m2;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Clay content/clay_01.mat');
clay_01=mean(clay_01,3,'omitnan')/100;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Bulk density/bd_01.mat');
bd_01=mean(bd_01,3,'omitnan');

load('/Users/shuairen/Desktop/ظԭ__/warming/area_01_km2.mat','area_01_km2');
mask_area1=area_01_km2;
mask_area1=mask_area1+mask_tp; mask_area1=mask_area1(501:650,2501:2850);

grids_oc=(grids_oc.*mask_area1)/(10^6);


for i=1:16
    npp(:,:,i)=(npp(:,:,i).*mask_area1)*10^6/(10^15);
end
npp(:,:,end)=[];


pre(:,:,[1:99 115:end])=[]; tmp(:,:,[1:99 115:end])=[];%%%% 2000-2015
pre=imresample([0.5,0.5],pre,[0.09987,0.09976],'nearest'); tmp=imresample([0.5,0.5],tmp,[0.09987,0.09976],'nearest');

for i=1:15
    pre(:,:,i)=pre(:,:,i)+mask_tp;
    tmp(:,:,i)=tmp(:,:,i)+mask_tp;
end

tmp=tmp(501:650,2501:2850,:);
pre=pre(501:650,2501:2850,:);


tai_npp1=cat(3,tai_histnpp_stocks,tai_ssp585npp_stocks);
tai_pr1=cat(3,tai_histpr,tai_ssp585pr);
tai_tas1=cat(3,tai_histtas,tai_ssp585tas);

%%%% delta method
load('/Volumes/TU200Pro/4 paper-C turnover/2./ccsm4_mask_area.mat','mask_area');
deg_lo=360/288; deg_la=180/192;
for i=1:101
    st=tai_tas1(:,:,i);
    st=imresample([deg_lo deg_la],st,[0.09966,0.0995],'nearest');
    st=st+mask_tp; st=st(501:650,2501:2850);
    tai_tas(:,:,i)=st;
    
    pr=tai_pr1(:,:,i);
    pr=imresample([deg_lo deg_la],pr,[0.09966,0.0995],'nearest');
    pr=pr+mask_tp; pr=pr(501:650,2501:2850);
    tai_pr(:,:,i)=pr;
    
    fvs=tai_npp1(:,:,i);
    fvs=fvs./mask_area;
    fvs=imresample([deg_lo deg_la],fvs,[0.09966,0.0995],'nearest');
    fvs=fvs.*area_01_km2;
    fvs=fvs+mask_tp; fvs=fvs(501:650,2501:2850);
    tai_npp(:,:,i)=fvs;
end


a=tai_tas(:,:,1:15); tai_tas(:,:,1:15)=[];
b=tai_pr(:,:,1:15); tai_pr(:,:,1:15)=[];
c=tai_npp(:,:,1:15); tai_npp(:,:,1:15)=[];


de_tas1=cat(3,a,a,a,a,a,a); de_tas1(:,:,87:end)=[];
de_tas=cat(3,tmp,tmp,tmp,tmp,tmp,tmp); de_tas(:,:,87:end)=[];
de_pr1=cat(3,b,b,b,b,b,b); de_pr1(:,:,87:end)=[];
de_pr=cat(3,pre,pre,pre,pre,pre,pre); de_pr(:,:,87:end)=[];
de_npp1=cat(3,c,c,c,c,c,c); de_npp1(:,:,87:end)=[];
de_npp=cat(3,npp,npp,npp,npp,npp,npp); de_npp(:,:,87:end)=[];

for i=1:86
    a1=tai_tas(:,:,i); b1=tai_pr(:,:,i); c1=tai_npp(:,:,i);
    tai_tas(:,:,i)=mean(de_tas(:,:,1:15),3,'omitnan')+(a1-mean(de_tas1(:,:,1:15),3,'omitnan'));
    tai_pr(:,:,i)=mean(de_pr(:,:,1:15),3,'omitnan').*(b1./mean(de_pr1(:,:,1:15),3,'omitnan'));
    tai_npp(:,:,i)=mean(de_npp(:,:,1:15),3,'omitnan')+(c1-mean(de_npp1(:,:,1:15),3,'omitnan'));
    
end

load('/Volumes/TU200Pro/4 paper-C turnover/7.Physical protection/3.constrain_hamdi/1 changed_all/max_pre.mat','max_pre');
for i=1:86
    
    tai_pr(:,:,i)=tai_pr(:,:,i)/max_pre;
end


clay_01=clay_01+mask_tp; clay_01=clay_01(501:650,2501:2850);
bd_01=bd_01+mask_tp; bd_01=bd_01(501:650,2501:2850);

nu=52500;

fc=reshape(fc,[1,nu]);
sc=reshape(sc,[1,nu]);
fmrt=reshape(fmrt,[1,nu]);
smrt=reshape(smrt,[1,nu]);
pmrt=reshape(pmrt,[1,nu]);
grids_oc=reshape(grids_oc,[1,nu]);
clay_01=reshape(clay_01,[1,nu]);
bd_01=reshape(bd_01,[1,nu]);
mask_area2=reshape(mask_area1,[1,nu])*10^6;
bd_01=bd_01.*mask_area2/10;

for i=1:86
    hst(i,:)=reshape(tai_tas(:,:,i),[1,nu]);
    hswc(i,:)=reshape(tai_pr(:,:,i),[1,nu]);
    hfs(i,:)=reshape(tai_npp(:,:,i),[1,nu]);
end

ctotal=grids_oc;
hcfs=ctotal.*fc; hcms=ctotal.*sc; hcss=ctotal.*(1-fc-sc);
mrt=cat(1,fmrt,smrt,pmrt,clay_01,bd_01);

path='/Users/shuairen/Desktop/ظԭ__/warming/';
load(strcat(path,'consPAR_TP.mat'));
load(strcat(path,'soc_spinup.mat'));


hcfs=mean(hfs_mo,1,'omitnan'); hcms=mean(hms_mo,1,'omitnan'); hcss=mean(hss_mo,1,'omitnan');

tai_ssp585pre_hfs(1,:)=hcfs(1,:);tai_ssp585pre_hms(1,:)=hcms(1,:); tai_ssp585pre_hss(1,:)=hcss(1,:);
for j=1:nu
    cm_last(1,1)=hcfs(1,j); cm_last(2,1)=hcms(1,j); cm_last(3,1)=hcss(1,j);
    for i=1:86
        f_tem=had1(4,j)^((hst(i,j)-15)/10); s_tem=had1(5,j)^((hst(i,j)-15)/10); p_tem=had1(6,j)^((hst(i,j)-15)/10);
        f_moi=(hswc(i,j))^had1(3,j); s_moi=(hswc(i,j))^had1(3,j); p_moi=(hswc(i,j))^had1(3,j);
        if mrt(4,j)==0
            clay=1;
        elseif mrt(4,j)>0 && mrt(4,j)<0.033
            clay=1/(mrt(4,j)*19.6);
        elseif mrt(4,j)>0.033 || mrt(4,j)==0.033
            clay=1/(-2.13*mrt(4,j)^2+6.23*mrt(4,j)+0.55);
        else
            clay=nan;
        end
        
        f_app(i,j)=mrt(1,j)/(f_tem*f_moi*clay);
        if cm_last(1,1)>0
            s_in=cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(cm_last(1,1)+hfs(i,j))*had1(1,j);
            end
        else
            s_in=hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(hfs(i,j))*had1(1,j);
            end
        end
        s_res=s_in*10^14*7.05/(365*mrt(5,j));
        s_pri=1+((2.47*s_res)/(13.01+s_res));
        s_app(i,j)=mrt(2,j)/(s_tem*s_moi*clay)/s_pri;
        
        p_in=cm_last(2,1)*had1(2,j)/s_app(i,j);
        p_res=p_in*10^14*7.05/(365*mrt(5,j));
        p_pri=1+((2.47*p_res)/(13.01+p_res));
        
        p_app(i,j)=mrt(3,j)/(p_tem*p_moi*clay)/p_pri;
        
        if cm_last(1,1)>0
            cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+(cm_last(1,1)+hfs(i,j))*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        else
            cm_present(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        end
        
        %         cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
        %         cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had(1,j)/f_app(i,j);
        %         cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had(2,j)/s_app(i,j);
        
        cm_last=cm_present;
        tai_ssp585pre_hfs(i+1,j)=cm_present(1,1); tai_ssp585pre_hms(i+1,j)=cm_present(2,1); tai_ssp585pre_hss(i+1,j)=cm_present(3,1);
    end
end

mask=tai_ssp585pre_hfs(end,:)-tai_ssp585pre_hfs(1,:); mask(mask>-10^100)=0;

%%% original C
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histcf_stocks.mat','tai_histcf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histcm_stocks.mat','tai_histcm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histcs_stocks.mat','tai_histcs_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/TaiESM1/tai_ssp585cf_stocks.mat','tai_ssp585cf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/TaiESM1/tai_ssp585cm_stocks.mat','tai_ssp585cm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/TaiESM1/tai_ssp585cs_stocks.mat','tai_ssp585cs_stocks');
    
tai_histcf_stocks=mean(tai_histcf_stocks,3,'omitnan');
tai_histcm_stocks=mean(tai_histcm_stocks,3,'omitnan');
tai_histcs_stocks=mean(tai_histcs_stocks,3,'omitnan');
tai_ssp585cf_stocks=cat(3,tai_histcf_stocks,tai_ssp585cf_stocks);
tai_ssp585cm_stocks=cat(3,tai_histcm_stocks,tai_ssp585cm_stocks);
tai_ssp585cs_stocks=cat(3,tai_histcs_stocks,tai_ssp585cs_stocks);

%%% pre-industrial temperature
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histtas.mat','tai_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp585/TaiESM1/tai_ssp585tas.mat','tai_ssp585tas');
tai_histtas(:,:,51:end)=[]; tai_histtas=mean(tai_histtas,3,'omitnan');
tai_ssp585tas=cat(3,tai_histtas,tai_ssp585tas);

for i=1:87
    cf=tai_ssp585cf_stocks(:,:,i);
    cf=cf./mask_area;
    cf=imresample([deg_lo deg_la],cf,[0.09966,0.0995],'nearest');
    cf=cf.*area_01_km2;
    cf=cf(501:650,2501:2850);
    tai_ssp585cf_orig(:,:,i)=cf;
    cm=tai_ssp585cm_stocks(:,:,i);
    cm=cm./mask_area;
    cm=imresample([deg_lo deg_la],cm,[0.09966,0.0995],'nearest');
    cm=cm.*area_01_km2;
    cm=cm(501:650,2501:2850);
    tai_ssp585cm_orig(:,:,i)=cm;
    cs=tai_ssp585cs_stocks(:,:,i);
    cs=cs./mask_area;
    cs=imresample([deg_lo deg_la],cs,[0.09966,0.0995],'nearest');
    cs=cs.*area_01_km2;
    cs=cs(501:650,2501:2850);
    tai_ssp585cs_orig(:,:,i)=cs;
end


for j=1:87
    f=tai_ssp585pre_hfs(j,:);
    f=f+mask;
    f1=tai_ssp585cf_orig(:,:,j);
    f1=reshape(f1,1,nu);
    f1=f1+mask;
    hfs1(j,1)=sum(f(:),'omitnan');
    hfs1(j,2)=sum(f1(:),'omitnan');
    m=tai_ssp585pre_hms(j,:);
    m=m+mask;
    m1=tai_ssp585cm_orig(:,:,j);
    m1=reshape(m1,1,nu);
    m1=m1+mask;
    hfs1(j,3)=sum(m(:),'omitnan');
    hfs1(j,4)=sum(m1(:),'omitnan');
    s=tai_ssp585pre_hss(j,:);
    s=s+mask;
    s1=tai_ssp585cs_orig(:,:,j);
    s1=reshape(s1,1,nu);
    s1=s1+mask;
    hfs1(j,5)=sum(s(:),'omitnan');
    hfs1(j,6)=sum(s1(:),'omitnan');
    to=f+m+s;
    to1=f1+m1+s1;
    hfs1(j,7)=sum(to(:),'omitnan');
    hfs1(j,8)=sum(to1(:),'omitnan');
    pre2(:,:,j)=reshape(to,150,350);
    ori2(:,:,j)=reshape(to1,150,350);
    pre_f(:,:,j)=reshape(f,150,350);
pre_m(:,:,j)=reshape(m,150,350);
pre_s(:,:,j)=reshape(s,150,350);
    
    t1=tai_ssp585tas(:,:,j);
    hfs1(j,9)=mean(t1(:),'omitnan');
end

aa=hfs1(1,:);
for i=1:87
    hfs1(i,:)=hfs1(i,:)-aa;
end


yr=1:87;
plot(yr',hfs1(:,7));
hold on;
plot(yr',hfs1(:,8));

hfs1(:,9)=[];
hfs1= array2table(hfs1,...
    'VariableNames',{'pre_f','ori_f','pre_m','ori_m','pre_s','ori_s','pre_to','ori_to'});

path_out='/Users/shuairen/Desktop/ظԭ__/warming/ssp585/';

ssp585_taiPRE_f=pre_f;
ssp585_taiPRE_m=pre_m;
ssp585_taiPRE_s=pre_s;


save(strcat(path_out,'ssp585_tai_pools.mat'), 'ssp585_taiPRE_f','ssp585_taiPRE_m','ssp585_taiPRE_s');


% ssp585_taiORI=ori2;
% ssp585_taiPRE=pre2;
% save(strcat(path_out,'ssp585_tai.mat'),'ssp585_taiORI','ssp585_taiPRE'); %%% modis and soilgrids
% writetable(hfs1,strcat(path_out,'ssp585_tai_yearly.csv'),'WriteRowNames',false);




%% TaiESM1; prediction-ssp245; constrain; use for ѭ
clc;clear;
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histnpp_stocks.mat','tai_histnpp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histtas.mat','tai_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histpr.mat','tai_histpr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/TaiESM1/tai_ssp245npp_stocks.mat','tai_ssp245npp_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/TaiESM1/tai_ssp245tas.mat','tai_ssp245tas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/TaiESM1/tai_ssp245pr.mat','tai_ssp245pr');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/2. ˮ/pre.mat');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CRU_ts4.01/1. ¶/tmp.mat');

load('/Users/shuairen/Desktop/ظԭ__/warming/mask_tp.mat','mask_tp');

fc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fcp_tp_005.tif');
fc=double(fc); fc(fc<0)=nan;
sc=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/scp_tp_005.tif');
sc=double(sc); sc(sc<0)=nan;
fmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/fmrt_tp_005.tif');
fmrt=double(fmrt); fmrt(fmrt<0)=nan;
smrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/smrt_tp_005.tif');
smrt=double(smrt); smrt(smrt<0)=nan;
pmrt=imread('/Users/shuairen/Desktop/ظԭ__/warming/upscaling_turnover/pmrt_tp_005.tif');
pmrt=double(pmrt); pmrt(pmrt<0)=nan;

fc=imresample([0.05,0.05],fc,[0.1,0.1],'nearest');
sc=imresample([0.05,0.05],sc,[0.1,0.1],'nearest');
fmrt=imresample([0.05,0.05],fmrt,[0.1,0.1],'nearest');
smrt=imresample([0.05,0.05],smrt,[0.1,0.1],'nearest');
pmrt=imresample([0.05,0.05],pmrt,[0.1,0.1],'nearest');


npp2000=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2000_TP_01.tif');
npp2001=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2001_TP_01.tif');
npp2002=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2002_TP_01.tif');
npp2003=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2003_TP_01.tif');
npp2004=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2004_TP_01.tif');
npp2005=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2005_TP_01.tif');
npp2006=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2006_TP_01.tif');
npp2007=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2007_TP_01.tif');
npp2008=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2008_TP_01.tif');
npp2009=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2009_TP_01.tif');
npp2010=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2010_TP_01.tif');
npp2011=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2011_TP_01.tif');
npp2012=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2012_TP_01.tif');
npp2013=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2013_TP_01.tif');
npp2014=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2014_TP_01.tif');
npp2015=imread('/Users/shuairen/Desktop/ظԭ__/variables/modis_npp_tp/modis_npp_2015_TP_01.tif');

npp=cat(3,npp2000,npp2001,npp2002,npp2003,npp2004,npp2005,npp2006,npp2007,npp2008,npp2009,npp2010,npp2011,npp2012,npp2013,npp2014,npp2015);
npp=double(npp)/10; npp(npp>6500)=nan;
mask_fc=fc; mask_fc(mask_fc>0)=0;

for i=1:16
    npp(:,:,i)=npp(:,:,i)+mask_fc;
end

grids_oc=imread('/Users/shuairen/Desktop/ظԭ__/variables/socd/TP_1m_SOCD_kgCm2_01.tif');%%% λΪ kg/m2;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Clay content/clay_01.mat');
clay_01=mean(clay_01,3,'omitnan')/100;
load('/Volumes/TU200Pro/4 paper-C turnover/2./SoilGrids/Bulk density/bd_01.mat');
bd_01=mean(bd_01,3,'omitnan');

load('/Users/shuairen/Desktop/ظԭ__/warming/area_01_km2.mat','area_01_km2');
mask_area1=area_01_km2;
mask_area1=mask_area1+mask_tp; mask_area1=mask_area1(501:650,2501:2850);

grids_oc=(grids_oc.*mask_area1)/(10^6);


for i=1:16
    npp(:,:,i)=(npp(:,:,i).*mask_area1)*10^6/(10^15);
end
npp(:,:,end)=[];


pre(:,:,[1:99 115:end])=[]; tmp(:,:,[1:99 115:end])=[];%%%% 2000-2015
pre=imresample([0.5,0.5],pre,[0.09987,0.09976],'nearest'); tmp=imresample([0.5,0.5],tmp,[0.09987,0.09976],'nearest');

for i=1:15
    pre(:,:,i)=pre(:,:,i)+mask_tp;
    tmp(:,:,i)=tmp(:,:,i)+mask_tp;
end

tmp=tmp(501:650,2501:2850,:);
pre=pre(501:650,2501:2850,:);


tai_npp1=cat(3,tai_histnpp_stocks,tai_ssp245npp_stocks);
tai_pr1=cat(3,tai_histpr,tai_ssp245pr);
tai_tas1=cat(3,tai_histtas,tai_ssp245tas);

%%%% delta method
load('/Volumes/TU200Pro/4 paper-C turnover/2./ccsm4_mask_area.mat','mask_area');
deg_lo=360/288; deg_la=180/192;
for i=1:101
    st=tai_tas1(:,:,i);
    st=imresample([deg_lo deg_la],st,[0.09966,0.0995],'nearest');
    st=st+mask_tp; st=st(501:650,2501:2850);
    tai_tas(:,:,i)=st;
    
    pr=tai_pr1(:,:,i);
    pr=imresample([deg_lo deg_la],pr,[0.09966,0.0995],'nearest');
    pr=pr+mask_tp; pr=pr(501:650,2501:2850);
    tai_pr(:,:,i)=pr;
    
    fvs=tai_npp1(:,:,i);
    fvs=fvs./mask_area;
    fvs=imresample([deg_lo deg_la],fvs,[0.09966,0.0995],'nearest');
    fvs=fvs.*area_01_km2;
    fvs=fvs+mask_tp; fvs=fvs(501:650,2501:2850);
    tai_npp(:,:,i)=fvs;
end


a=tai_tas(:,:,1:15); tai_tas(:,:,1:15)=[];
b=tai_pr(:,:,1:15); tai_pr(:,:,1:15)=[];
c=tai_npp(:,:,1:15); tai_npp(:,:,1:15)=[];


de_tas1=cat(3,a,a,a,a,a,a); de_tas1(:,:,87:end)=[];
de_tas=cat(3,tmp,tmp,tmp,tmp,tmp,tmp); de_tas(:,:,87:end)=[];
de_pr1=cat(3,b,b,b,b,b,b); de_pr1(:,:,87:end)=[];
de_pr=cat(3,pre,pre,pre,pre,pre,pre); de_pr(:,:,87:end)=[];
de_npp1=cat(3,c,c,c,c,c,c); de_npp1(:,:,87:end)=[];
de_npp=cat(3,npp,npp,npp,npp,npp,npp); de_npp(:,:,87:end)=[];

for i=1:86
    a1=tai_tas(:,:,i); b1=tai_pr(:,:,i); c1=tai_npp(:,:,i);
    tai_tas(:,:,i)=mean(de_tas(:,:,1:15),3,'omitnan')+(a1-mean(de_tas1(:,:,1:15),3,'omitnan'));
    tai_pr(:,:,i)=mean(de_pr(:,:,1:15),3,'omitnan').*(b1./mean(de_pr1(:,:,1:15),3,'omitnan'));
    tai_npp(:,:,i)=mean(de_npp(:,:,1:15),3,'omitnan')+(c1-mean(de_npp1(:,:,1:15),3,'omitnan'));
    
end

load('/Volumes/TU200Pro/4 paper-C turnover/7.Physical protection/3.constrain_hamdi/1 changed_all/max_pre.mat','max_pre');
for i=1:86
    
    tai_pr(:,:,i)=tai_pr(:,:,i)/max_pre;
end


clay_01=clay_01+mask_tp; clay_01=clay_01(501:650,2501:2850);
bd_01=bd_01+mask_tp; bd_01=bd_01(501:650,2501:2850);

nu=52500;

fc=reshape(fc,[1,nu]);
sc=reshape(sc,[1,nu]);
fmrt=reshape(fmrt,[1,nu]);
smrt=reshape(smrt,[1,nu]);
pmrt=reshape(pmrt,[1,nu]);
grids_oc=reshape(grids_oc,[1,nu]);
clay_01=reshape(clay_01,[1,nu]);
bd_01=reshape(bd_01,[1,nu]);
mask_area2=reshape(mask_area1,[1,nu])*10^6;
bd_01=bd_01.*mask_area2/10;

for i=1:86
    hst(i,:)=reshape(tai_tas(:,:,i),[1,nu]);
    hswc(i,:)=reshape(tai_pr(:,:,i),[1,nu]);
    hfs(i,:)=reshape(tai_npp(:,:,i),[1,nu]);
end

ctotal=grids_oc;
hcfs=ctotal.*fc; hcms=ctotal.*sc; hcss=ctotal.*(1-fc-sc);
mrt=cat(1,fmrt,smrt,pmrt,clay_01,bd_01);

path='/Users/shuairen/Desktop/ظԭ__/warming/';
load(strcat(path,'consPAR_TP.mat'));
load(strcat(path,'soc_spinup.mat'));


hcfs=mean(hfs_mo,1,'omitnan'); hcms=mean(hms_mo,1,'omitnan'); hcss=mean(hss_mo,1,'omitnan');

tai_ssp245pre_hfs(1,:)=hcfs(1,:);tai_ssp245pre_hms(1,:)=hcms(1,:); tai_ssp245pre_hss(1,:)=hcss(1,:);
for j=1:nu
    cm_last(1,1)=hcfs(1,j); cm_last(2,1)=hcms(1,j); cm_last(3,1)=hcss(1,j);
    for i=1:86
        f_tem=had1(4,j)^((hst(i,j)-15)/10); s_tem=had1(5,j)^((hst(i,j)-15)/10); p_tem=had1(6,j)^((hst(i,j)-15)/10);
        f_moi=(hswc(i,j))^had1(3,j); s_moi=(hswc(i,j))^had1(3,j); p_moi=(hswc(i,j))^had1(3,j);
        if mrt(4,j)==0
            clay=1;
        elseif mrt(4,j)>0 && mrt(4,j)<0.033
            clay=1/(mrt(4,j)*19.6);
        elseif mrt(4,j)>0.033 || mrt(4,j)==0.033
            clay=1/(-2.13*mrt(4,j)^2+6.23*mrt(4,j)+0.55);
        else
            clay=nan;
        end
        
        f_app(i,j)=mrt(1,j)/(f_tem*f_moi*clay);
        if cm_last(1,1)>0
            s_in=cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(cm_last(1,1)+hfs(i,j))*had1(1,j);
            end
        else
            s_in=hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present2(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            if cm_present2(1,1)<0
                s_in=(hfs(i,j))*had1(1,j);
            end
        end
        s_res=s_in*10^14*7.05/(365*mrt(5,j));
        s_pri=1+((2.47*s_res)/(13.01+s_res));
        s_app(i,j)=mrt(2,j)/(s_tem*s_moi*clay)/s_pri;
        
        p_in=cm_last(2,1)*had1(2,j)/s_app(i,j);
        p_res=p_in*10^14*7.05/(365*mrt(5,j));
        p_pri=1+((2.47*p_res)/(13.01+p_res));
        
        p_app(i,j)=mrt(3,j)/(p_tem*p_moi*clay)/p_pri;
        
        if cm_last(1,1)>0
            cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+(cm_last(1,1)+hfs(i,j))*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        else
            cm_present(1,1)=(1-1/f_app(i,j))*hfs(i,j);
            cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j)/f_app(i,j);
            cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            if cm_present(1,1)<0
                cm_present(1,1)=0;
                cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+hfs(i,j)*had1(1,j);
                cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had1(2,j)/s_app(i,j);
            end
        end
        
        %         cm_present(1,1)=(1-1/f_app(i,j))*cm_last(1,1)+hfs(i,j);
        %         cm_present(2,1)=(1-1/s_app(i,j))*cm_last(2,1)+cm_last(1,1)*had(1,j)/f_app(i,j);
        %         cm_present(3,1)=(1-1/p_app(i,j))*cm_last(3,1)+cm_last(2,1)*had(2,j)/s_app(i,j);
        
        cm_last=cm_present;
        tai_ssp245pre_hfs(i+1,j)=cm_present(1,1); tai_ssp245pre_hms(i+1,j)=cm_present(2,1); tai_ssp245pre_hss(i+1,j)=cm_present(3,1);
    end
end

mask=tai_ssp245pre_hfs(end,:)-tai_ssp245pre_hfs(1,:); mask(mask>-10^100)=0;

%%% original C
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histcf_stocks.mat','tai_histcf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histcm_stocks.mat','tai_histcm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histcs_stocks.mat','tai_histcs_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/TaiESM1/tai_ssp245cf_stocks.mat','tai_ssp245cf_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/TaiESM1/tai_ssp245cm_stocks.mat','tai_ssp245cm_stocks');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/TaiESM1/tai_ssp245cs_stocks.mat','tai_ssp245cs_stocks');
    
tai_histcf_stocks=mean(tai_histcf_stocks,3,'omitnan');
tai_histcm_stocks=mean(tai_histcm_stocks,3,'omitnan');
tai_histcs_stocks=mean(tai_histcs_stocks,3,'omitnan');
tai_ssp245cf_stocks=cat(3,tai_histcf_stocks,tai_ssp245cf_stocks);
tai_ssp245cm_stocks=cat(3,tai_histcm_stocks,tai_ssp245cm_stocks);
tai_ssp245cs_stocks=cat(3,tai_histcs_stocks,tai_ssp245cs_stocks);

%%% pre-industrial temperature
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/historical/TaiESM1/tai_histtas.mat','tai_histtas');
load('/Volumes/TU200Pro/4 paper-C turnover/2./CMIP6/ssp245/TaiESM1/tai_ssp245tas.mat','tai_ssp245tas');
tai_histtas(:,:,51:end)=[]; tai_histtas=mean(tai_histtas,3,'omitnan');
tai_ssp245tas=cat(3,tai_histtas,tai_ssp245tas);

for i=1:87
    cf=tai_ssp245cf_stocks(:,:,i);
    cf=cf./mask_area;
    cf=imresample([deg_lo deg_la],cf,[0.09966,0.0995],'nearest');
    cf=cf.*area_01_km2;
    cf=cf(501:650,2501:2850);
    tai_ssp245cf_orig(:,:,i)=cf;
    cm=tai_ssp245cm_stocks(:,:,i);
    cm=cm./mask_area;
    cm=imresample([deg_lo deg_la],cm,[0.09966,0.0995],'nearest');
    cm=cm.*area_01_km2;
    cm=cm(501:650,2501:2850);
    tai_ssp245cm_orig(:,:,i)=cm;
    cs=tai_ssp245cs_stocks(:,:,i);
    cs=cs./mask_area;
    cs=imresample([deg_lo deg_la],cs,[0.09966,0.0995],'nearest');
    cs=cs.*area_01_km2;
    cs=cs(501:650,2501:2850);
    tai_ssp245cs_orig(:,:,i)=cs;
end


for j=1:87
    f=tai_ssp245pre_hfs(j,:);
    f=f+mask;
    f1=tai_ssp245cf_orig(:,:,j);
    f1=reshape(f1,1,nu);
    f1=f1+mask;
    hfs1(j,1)=sum(f(:),'omitnan');
    hfs1(j,2)=sum(f1(:),'omitnan');
    m=tai_ssp245pre_hms(j,:);
    m=m+mask;
    m1=tai_ssp245cm_orig(:,:,j);
    m1=reshape(m1,1,nu);
    m1=m1+mask;
    hfs1(j,3)=sum(m(:),'omitnan');
    hfs1(j,4)=sum(m1(:),'omitnan');
    s=tai_ssp245pre_hss(j,:);
    s=s+mask;
    s1=tai_ssp245cs_orig(:,:,j);
    s1=reshape(s1,1,nu);
    s1=s1+mask;
    hfs1(j,5)=sum(s(:),'omitnan');
    hfs1(j,6)=sum(s1(:),'omitnan');
    to=f+m+s;
    to1=f1+m1+s1;
    hfs1(j,7)=sum(to(:),'omitnan');
    hfs1(j,8)=sum(to1(:),'omitnan');
    pre2(:,:,j)=reshape(to,150,350);
    ori2(:,:,j)=reshape(to1,150,350);
    pre_f(:,:,j)=reshape(f,150,350);
pre_m(:,:,j)=reshape(m,150,350);
pre_s(:,:,j)=reshape(s,150,350);
    
    t1=tai_ssp245tas(:,:,j);
    hfs1(j,9)=mean(t1(:),'omitnan');
end

aa=hfs1(1,:);
for i=1:87
    hfs1(i,:)=hfs1(i,:)-aa;
end


yr=1:87;
plot(yr',hfs1(:,7));
hold on;
plot(yr',hfs1(:,8));

hfs1(:,9)=[];
hfs1= array2table(hfs1,...
    'VariableNames',{'pre_f','ori_f','pre_m','ori_m','pre_s','ori_s','pre_to','ori_to'});

path_out='/Users/shuairen/Desktop/ظԭ__/warming/ssp245/';

ssp245_taiPRE_f=pre_f;
ssp245_taiPRE_m=pre_m;
ssp245_taiPRE_s=pre_s;


save(strcat(path_out,'ssp245_tai_pools.mat'), 'ssp245_taiPRE_f','ssp245_taiPRE_m','ssp245_taiPRE_s');


% ssp245_taiORI=ori2;
% ssp245_taiPRE=pre2;
% save(strcat(path_out,'ssp245_tai.mat'),'ssp245_taiORI','ssp245_taiPRE'); %%% modis and soilgrids
% writetable(hfs1,strcat(path_out,'ssp245_tai_yearly.csv'),'WriteRowNames',false);
